<?php
/*
Plugin Name: Przykład skrótu nr 4
Plugin URI: http:/przyklad.pl/
Description: Zastąpienie znacznika [amazonobraz] obrazem z serwisu Amazon.
Version: 1.0
Author: Ozh
Author URI: http://wrox.com/
*/

// Rejestracja skrótów [amazonobraz] i [obrazamazon]
add_shortcode( 'amazonobraz', 'boj_sc4_amazonimage' );
add_shortcode( 'obrazamazon', 'boj_sc4_amazonimage' );

// Funkcja odpowiedzialna za zastąpienie skrótu [amazonobraz].
function boj_sc4_amazonimage( $attr, $content ) {

    // Pobranie numeru ASIN lub ustawienie domyślnego.
    $possible = array( 'asin', 'isbn' );
    $asin = boj_sc4_find( $possible, $attr, '0470560541' );
    
    // Pobranie powiązanego identyfikatora lub ustawienie domyślnego.
    $possible = array( 'aff', 'affiliate' );
    $aff = boj_sc4_find( $possible, $attr, 'aff_id' );
    
    // Pobranie wielkości obrazu, jeśli podano.
    $possible = array( 'wielkosc', 'obraz', 'wielkoscobrazu' );
    $size = boj_sc4_find( $possible, $attr, '' );
    
    // Pobranie typu, jeśli podano.
    if( isset( $attr['type'] ) ) {
        $type = strtolower( $attr['typ'] );
        $type = ( $type == 'cd' or $type == 'dysk' ) ? 'cd' : '';
    }
    
    // Utworzenie adresu URL prowadzącego do obrazu w serwisie Amazon.
    $img = 'http://images.amazon.com/images/P/';
    $img .= $asin;
    // Opcje obrazu: wielkość.
    if( $size ) {
        switch( $size ) {
            case 'maly':
                $size = '_AA100';
                break;
            default:
            case 'sredni':
                $size = '_AA175';
                break;
            case 'duzy':
            case 'ogromny':
                $size = '_SCLZZZZZZZ';
        }
    }
    // Opcje obrazu: typ.
    if( $type == 'cd' ) {
        $type = '_PF';
    }
    // Dołączenie opcji do adresu URL, o ile podano jakiekolwiek opcje.
    if( $type or $size ) {
        $img .= '.01.'.$type.$size;
    }
    // Zakończenie tworzenia adresu URL obrazu.
    $img .= '.jpg';
    
    // Trzeba pamiętać o zwróceniu obrazu.
    return "<a href='http://www.amazon.com/dp/$asin'><img src='$img' /></a>";
}

// Funkcja pomocnicza:
// Wyszukuje $find_keys w tablicy $in_array, zwraca $default jeśli nie znajdzie $find_keys.
function boj_sc4_find( $find_keys, $in_array, $default ) {
    foreach( $find_keys as $key ) {
        if( isset( $in_array[$key] ) )
            return $in_array[$key];
    }
    return $default;
}
?>
