<?php

// Weryfikacja przyszłej daty zapisanej w postaci mm/dd/rrrr.
// Wartością zwrotną jest true lub komunikat błędu.
function boj_validate_date( $date ) {
    // Pierwszy test: dopasowanie wzorca.
    if( !preg_match( '!\d{2}/\d{2}/\d{4}!', $date ) )
        return 'nieprawidłowy wzorzec';
    
    // Drugi test: czy data jest prawidłowa?
    $timestamp = strtotime( $date );
    if( !$timestamp )
        return 'data jest nieprawidłowa';
    
    // Trzeci test: czy data wskazuje dzień w przyszłości?
    if( $timestamp <= time() )
        return 'data wskazuje dzień z przeszłości';

    // Jak dotąd wszystko dobrze.
    return true;
}

// Sprawdzenie działania funkcji:

var_dump( boj_validate_date( '12/12/99' ) );
// string(22) "nieprawidłowy wzorzec"

var_dump( boj_validate_date( '35/30/1980' ) );
// string(24) "data jest nieprawidłowa"

var_dump( boj_validate_date( '03/30/1980' ) );
// string(36) "data wskazuje dzień z przeszłości"

var_dump( boj_validate_date( '03/30/2020' ) );
// bool(true)

