<?php 
/*
Plugin Name: Skrót przełaczania witryn sieci Multisite
Plugin URI: http://przyklad.pl/wtyczki-wordpress/moja-wtyczka
Description: Wtyczka agregująca treść za pomocą skrótu.
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

add_shortcode( 'network_posts', 'boj_multisite_network_posts' );

function boj_multisite_network_posts( $attr ) {
	extract( shortcode_atts( array(
			"blogid"	=>	'1',
			"num"		=>  '5'
			), $attr ) );

	if ( is_multisite() ) {
	
		$return_posts = '';
		
		// Przejście do witryny wskazanej w skrócie.
		switch_to_blog( absint( $blogid ) );

		// Utworzenie własnej pętli.
		$recentPosts = new WP_Query();
		$recentPosts->query( 'posts_per_page=' .absint( $num ) );
		
		// Rozpoczęcie wykonywania pętli.
		while ( $recentPosts->have_posts() ) : $recentPosts->the_post();
		
			// Przechowywanie ostatnio opublikowanych wpisów bloga w zmiennej.
			$return_posts .= '<p><a href="' .get_permalink(). '">' .get_the_title() .'</a></p>';
			
		endwhile;
		
		// Przywrócenie bieżącej witryny.
		restore_current_blog();
		
		// Zwrócenie wyników przeznaczonych do wyświetlenia.
		return $return_posts;
		
	}
}
?>
