<?php
/*
Plugin Name: Integracja z API Google Maps
Plugin URI: http://przyklad.pl/wtyczki-wordpresss/moja-wtyczka
Description: Wtyczka konwertuje adres zapisany w postaci zwykłego tekstu na mapę Google używając skrótu [google_map].
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

// Utworzenie geokodu na podstawie adresu: wartością zwrotną jest tablica zawierająca współrzędne geograficzne.
function boj_gmap_geocode( $address ) {
    // Utworzenie adresu URL do API Google Geocoding.
    $map_url = 'http://maps.google.com/maps/api/geocode/json?address=';
    $map_url .= urlencode( $address ).'&sensor=false';
    
    // Wykonanie żądania GET.
    $request = wp_remote_get( $map_url );

    // Pobranie obiektu JSON.
    $json = wp_remote_retrieve_body( $request );

    // Upewnienie się, że żądanie zakończyło się powodzeniem. W przeciwnym razie wartością zwrotną jest false.
    if( empty( $json ) )
        return false;
    
    // Odkodowanie obiektu JSON.
    $json = json_decode( $json );

		// Pobranie współrzędnych.
    $lat = $json->results[0]->geometry->location->lat;    // Szerokość geograficzna.
    $long = $json->results[0]->geometry->location->lng;   // Długość geograficzna.
    
    // Zwrócenie tablicy zawierającej współrzędne geograficzne.
    return compact( 'lat', 'long' );
}

// Konwersja adresu zapisanego w postaci zwykłego tekstu na współrzędne geograficzne.
function boj_gmap_get_coords( $address = 'ul. Kościuszki 1c, Gliwice' ) {
    
    // Identyfikator bieżącego wpisu bloga.
    global $id;
    
    // Sprawdzenie, czy współrzędne geograficzne znajdują się w bazie danych.
    $saved = get_post_meta( $id, 'boj_gmap_addresses' );
    foreach( (array)$saved as $_saved ) {
        if( isset( $_saved['address'] ) && $_saved['address'] == $address ) {
            extract( $_saved );
            return compact( 'lat', 'long' );
        }
    }
    
    // Współrzędne nie są jeszcze buforowane, więc trzeba je pobrać z Google.
    $coords = boj_gmap_geocode( $address );
    if( !$coords )
        return false;
    
    // Buforowanie wyniku w metadanych wpisu bloga.
    add_post_meta( $id, 'boj_gmap_addresses', array(
        'address' => $address,
        'lat' => $coords['lat'],
        'long' => $coords['long']
        )
    );
    
	// Zwrócenie tablicy zawierającej współrzędne geograficzne.
    extract( $coords );
    return compact( 'lat', 'long' );
}


// Dodanie obsługi skrótu [google_map].
add_shortcode( 'google_map', 'boj_gmap_generate_map' );
add_shortcode( 'googlemap', 'boj_gmap_generate_map' );

// Funkcja odpowiedzialna za obsługę skrótu.
function boj_gmap_generate_map( $attr, $address ) {

    // Ustawienie wartości domyślnych mapy.
    $defaults = array(
        'width'  => '500',
        'height' => '500',
        'zoom'   => 12,
    );
    
    // Pobranie atrybutów mapy (w przypadku ich pominięcia będą miały wartości domyślne).
    extract( shortcode_atts( $defaults, $attr ) );
    
    // Pobranie współrzędnych.
    $coord = boj_gmap_get_coords( $address );
    
    // Upewniamy się, że mamy współrzędne. W przeciwnym razie trzeba zwrócić pusty ciąg tekstowy.
    if( !$coord )
        return '';
        
    // Dane wyjściowe skrótu.
    $output = '';
        
    // Przypisanie wartości zmiennym $lat i $long.
    extract( $coord );
    
    // Oczyszczenie zmiennych w zależności od kontekstu, w którym będą użyte.
    $lat     = esc_js( $lat );
    $long    = esc_js( $long );
    $address = esc_js( $address );
    $zoom    = esc_js( $zoom );
    $width   = esc_attr( $width );
    $height  = esc_attr( $height );
    
    // Wygenerowanie unikalnego identyfikatora mapy, co pozwala mieć wiele map na stronie.
    $map_id = 'boj_map_'.md5( $address );
    
    // Tylko jednokrotne dodanie głównego skryptu Google Maps na stronie.
    static $script_added = false;
    if( $script_added == false ) {
        $output .= '<script type="text/javascript"
        src="http://maps.google.com/maps/api/js?sensor=false"></script>';
        $script_added = true;
    }
    
    // Dodanie kodu dotyczącego mapy.
    $output .= <<<CODE
    <div id="$map_id"></div>
    
    <script type="text/javascript">
    function generate_$map_id() {
        var latlng = new google.maps.LatLng( $lat, $long );
        var options = {
            zoom: $zoom,
            center: latlng,
            mapTypeId: google.maps.MapTypeId.ROADMAP
        }

        var map = new google.maps.Map(
            document.getElementById("$map_id"),
            options
        );

        var legend = '<div class="map_legend"><p> $address </p></div>';

        var infowindow = new google.maps.InfoWindow({
            content: legend,
        });

        var marker = new google.maps.Marker({
            position: latlng,
            map: map,
        });
        
        google.maps.event.addListener(marker, 'click', function() {
            infowindow.open(map,marker);
        });

    }

    generate_$map_id();
    
    </script>
    
    <style type"text/css">
    .map_legend{
        width:200px;
        max-height:200px;
        min-height:100px;
    }
    #$map_id {
        width: {$width}px;
        height: {$height}px;
    }
    </style>
    
CODE;

    return $output;
}

?>
