describe('user sign in flow', () => {
  it('should allow a user to sign in and out', () => {
    cy.createUser().then(({ user }) => {
      // Testowanie funkcjonalności logowania.
      cy.visit('/')
        .queryByText('Logowanie')
        .click()
        .queryByLabelText('E-mail:')
        .type(user.email)
        .queryByLabelText('Hasło:')
        .type(user.password)
        .queryByText('Zaloguj się')
        .click()
        .url()
        .should('eq', `${Cypress.config().baseUrl}/`)
        .window()
        .its('localStorage.token')
        .should('exist')
        .queryByText('Wyloguj się')
        .click()
        .window()
        .its('localStorage.token')
        .should('not.exist');
    });
  });
});
