import React from 'react';
import { Text, View } from 'react-native';
import { useQuery, gql } from '@apollo/client';

import Note from '../components/Note';
import Loading from '../components/Loading';

// Zapytanie notatki pobierające zmienną identyfikatora.
const GET_NOTE = gql`
  query note($id: ID!) {
    note(id: $id) {
      id
      createdAt
      content
      favoriteCount
      author {
        username
        id
        avatar
      }
    }
  }
`;

const NoteScreen = props => {
  const id = props.navigation.getParam('id');
  const { loading, error, data } = useQuery(GET_NOTE, { variables: { id } });

  if (loading) return <Loading />;
  // Jeżeli wystąpi błąd, trzeba wyświetlić komunikat błędu.
  if (error) return <Text>Błąd! Nie znaleziono notatki.</Text>;
  // Jeżeli operacja zakończy się sukcesem, dane należy przekazać do komponentu note.
  return <Note note={data.note} />;
};

export default NoteScreen;
