const express = require('express');
const { ApolloServer } = require('apollo-server-express');
require('dotenv').config();

const db = require('./db');
const models = require('./models');
const typeDefs = require('./schema');
const resolvers = require('./resolvers');

// Uruchomienie serwera nasłuchującego na porcie wskazanym w pliku .env, czyli na porcie 4000.
const port = process.env.PORT || 4000;
const DB_HOST = process.env.DB_HOST;

const app = express();

db.connect(DB_HOST);

// Konfiguracja serwera Apollo.
const server = new ApolloServer({
  typeDefs,
  resolvers,
  context: () => {
    // Dodanie do kontekstu modeli bazy danych.
    return { models };
  }
});

// Zastosowanie oprogramowania pośredniczącego Apollo GraphQL i zdefiniowanie ścieżki dostępu do /api.
server.applyMiddleware({ app, path: '/api' });

app.listen({ port }, () =>
  console.log(
    `Serwer GraphQL działa pod adresem http://localhost:${port}${server.graphqlPath}`
  )
);
