import React, { useEffect } from 'react';
import { useMutation, useApolloClient } from '@apollo/client';

import UserForm from '../components/UserForm';
import { SIGNIN_USER } from '../gql/mutation';

const SignIn = props => {
  useEffect(() => {
    // Uaktualnienie tytułu strony.
    document.title = 'Logowanie — Notedly';
  });

  const client = useApolloClient();
  const [signIn, { loading, error }] = useMutation(SIGNIN_USER, {
    onCompleted: data => {
      // Przechowywanie tokena JWT w magazynie danych localStorage.
      localStorage.setItem('token', data.signIn);
      // Uaktualnienie bufora lokalnego.
      client.writeData({ data: { isLoggedIn: true } });
      // Przekierowanie użytkownika na stronę główną.
      props.history.push('/');
    }
  });

  return (
    <React.Fragment>
      <UserForm action={signIn} formType="signIn" />
      {/* Jeżeli dane są wczytywane, należy wyświetlić odpowiedni komunikat. */}
      {loading && <p>Wczytywanie...</p>}
      {/* Jeżeli wystąpi błąd, należy wyświetlić komunikat błędu. */}
      {error && <p>Błąd podczas uwierzytelniania!</p>}
    </React.Fragment>
  );
};

export default SignIn;
