import React, { useEffect } from 'react';
import * as SecureStore from 'expo-secure-store';

import Loading from '../components/Loading';

const AuthLoading = props => {
  const checkLoginState = async () => {
    // Pobranie wartości tokena.
    const userToken = await SecureStore.getItemAsync('token');
    // Jeżeli token istnieje, należy przejść do ekranu aplikacji.
    // W przeciwnym razie trzeba przejść do ekranu uwierzytelnienia.
    props.navigation.navigate(userToken ? 'App' : 'Auth');
  };

  // Wywołanie checkLoginState() podczas montowania komponentu.
  useEffect(() => {
    checkLoginState();
  });

  return <Loading />;
};

export default AuthLoading;
