// Podziękowania dla Alex'a Martineza & Petera Piekarczyka za inspirację dla konfiguracji środowiska.
// https://medium.com/@peterpme/environment-variables-in-expo-using-release-channels-4934594c5307
// https://alxmrtnz.com/thoughts/2019/03/12/environment-variables-and-workflow-in-expo.html
import Constants from 'expo-constants';

// Pobranie adresu IP hosta lokalnego, w trakcie działania aplikacji i za pomocą manifestu Expo.
// To pozwala na debugowanie za pomocą symulatora i urządzenia fizycznego oraz z wykorzystaniem naszego lokalnego API.
let localhost;
if (Constants.manifest.debuggerHost) {
  localhost = Constants.manifest.debuggerHost.split(':').shift();
}

// Zdefiniowanie zmiennych środowiskowych.
const ENV = {
  dev: {
    API_URI: `http://${localhost}:4000/api`
  },
  prod: {
    // Uaktualnienie wartości API_URI adresem publicznie wdrożonego API.
    API_URI: 'https://<PUBLIC-API-URI>'
  }
};

const getEnvVars = (env = Constants.manifest.releaseChannel) => {
  // Przypisanie zmiennej __DEV__ wartości true, gdy react-native działa lokalnie w środowisku programistycznym.
  // Przypisanie zmiennej __DEV__ wartości false, gdy aplikacja została opublikowana.
  if (__DEV__) {
    return ENV.dev;
  } else if (env === 'prod') {
    return ENV.prod;
  }
};

export default getEnvVars;
