import React from 'react';
import { View, Text } from 'react-native';
// Import bibliotek Apollo.
import { useQuery, gql } from '@apollo/client';

import NoteFeed from '../components/NoteFeed';
import Loading from '../components/Loading';

// Przygotowanie zapytania.
const GET_NOTES = gql`
  query notes {
    notes {
      id
      createdAt
      content
      favoriteCount
      author {
        username
        id
        avatar
      }
    }
  }
`;

const Feed = props => {
  const { loading, error, data } = useQuery(GET_NOTES);

  // Podczas wczytywania danych, należy wyświetlić odpowiedni komunikat.
  if (loading) return <Loading />;
  // Jeżeli podczas pobierania danych wystąpi błąd, należy wyświetlić komunikat błędu.
  if (error) return <Text>Błąd podczas pobierania notatek.</Text>;
  // Jeżeli zapytanie zakończy się sukcesem i są notatki, należy zwrócić kanał notatek.
  return <NoteFeed notes={data.notes} navigation={props.navigation} />;
};

Feed.navigationOptions = {
  title: 'Kanał notatek'
};

export default Feed;
