// Wymagana jest biblioteka mongoose.
const mongoose = require('mongoose');

// Zdefiniowanie schematu bazy danych notatek.
const noteSchema = new mongoose.Schema(
  {
    content: {
      type: String,
      required: true
    },
    // Odwołanie do identyfikatora obiektu przedstawiającego autora.
    author: {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'User',
      required: true
    },
    favoriteCount: {
      type: Number,
      default: 0
    },
    favoritedBy: [
      {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User'
      }
    ]
  },
  {
    // Przypisanie właściwości createdAt i updatedAt typu Date.
    timestamps: true
  }
);

// Zdefiniowanie modelu Note wraz ze schematem.
const Note = mongoose.model('Note', noteSchema);
// Eksport modułu.
module.exports = Note;
