// Import biblioteki React i zależności routingu.
import React from 'react';
import { BrowserRouter as Router, Route } from 'react-router-dom';

// Import komponentu układu współdzielonego.
import Layout from '../components/Layout';

// Import tras.
import Home from './home';
import MyNotes from './mynotes';
import Favorites from './favorites';
import Note from './note';

// Definicje tras.
const Pages = () => {
  return (
    <Router>
      <Layout>
        <Route exact path="/" component={Home} />
        <Route path="/mynotes" component={MyNotes} />
        <Route path="/favorites" component={Favorites} />
        <Route path="/note/:id" component={Note} />
      </Layout>
    </Router>
  );
};

export default Pages;
