import React from 'react';
import ReactMarkdown from 'react-markdown';
import { format } from 'date-fns';
import styled from 'styled-components';

// Szerokość notatki nie może przekroczyć 800 pikseli.
const StyledNote = styled.article`
  max-width: 800px;
  margin: 0 auto;
`;

// Nadanie stylu metadanym notatki.
const MetaData = styled.div`
  @media (min-width: 500px) {
    display: flex;
    align-items: top;
  }
`;

// Dodanie wolnego miejsca między awatarem i informacjami.
const MetaInfo = styled.div`
  padding-right: 1em;
`;

// Na dużym ekranie element 'UserActions' ma być dosunięty do prawej strony.
const UserActions = styled.div`
  margin-left: auto;
`;

const Note = ({ note }) => {
  return (
    <StyledNote>
      <MetaData>
        <MetaInfo>
          <img
            src={note.author.avatar}
            alt={`${note.author.username} avatar`}
            height="50px"
          />
        </MetaInfo>
        <MetaInfo>
          <em>autor</em> {note.author.username} <br />
          {format(note.createdAt, 'Do MMM YYYY')}
        </MetaInfo>
        <UserActions>
          <em>Ulubione:</em> {note.favoriteCount}
        </UserActions>
      </MetaData>
      <ReactMarkdown source={note.content} />
    </StyledNote>
  );
};

export default Note;
