import { userBuilder } from '../support/generate';

describe('user registration', () => {
  it('should register a new user', () => {
    const user = userBuilder();
    cy.visit('/')
      .queryByText('Rejestracja')
      .click()
      .queryByLabelText('Nazwa użytkownika:')
      .type(user.username)
      .queryByLabelText('E-mail:')
      .type(user.email)
      .queryByLabelText('Hasło:')
      .type(user.password)
      .queryByText('Zaloguj się')
      .click()
      .url()
      .should('eq', `${Cypress.config().baseUrl}/`)
      .window()
      .its('localStorage.token')
      .should('be.a', 'string');
  });
});
