const { app, BrowserWindow } = require('electron');
const { is } = require('electron-util');

// Aby uniknąć mechanizmu usuwania nieużytków, okno należy zadeklarować jako zmienną.
let window;

// Określenie szczegółów okna przeglądarki WWW.
function createWindow() {
  window = new BrowserWindow({
    width: 800,
    height: 600,
    webPreferences: {
      nodeIntegration: true
    }
  });

  // Wczytanie pliku HTML.
  window.loadFile('index.html');

  // Po uruchomieniu aplikacji w trybie programistycznym, automatycznie nastąpi wyświetlenie panelu narzędzi.
  if (is.development) {
    window.webContents.openDevTools();
  }

  // Po zamknięciu okna należy wyzerować jego obiekt.
  window.on('closed', () => {
    window = null;
  });
}

// Gdy framework Electron będzie gotowy, należy utworzyć okno aplikacji.
app.on('ready', createWindow);

// Zakończenie działania po zamknięciu wszystkich okien.
app.on('window-all-closed', () => {
  // W systemie macOS zakończenie aplikacji musi być wyraźnie wymuszone.
  if (process.platform !== 'darwin') {
    app.quit();
  }
});

app.on('activate', () => {
  // W systemie macOS kliknięcie ikony aplikacji w Docku spowoduje wyświetlenie jej okna.
  if (window === null) {
    createWindow();
  }
});
