const { app, BrowserWindow } = require('electron');
const { is, setContentSecurityPolicy } = require('electron-util');
const config = require('./config');

// Aby uniknąć mechanizmu usuwania nieużytków, okno należy zadeklarować jako zmienną.
let window;

// Określenie szczegółów okna przeglądarki WWW.
function createWindow() {
  window = new BrowserWindow({
    width: 800,
    height: 600,
    webPreferences: {
      nodeIntegration: false
    }
  });

  // Wczytanie danych z podanego adresu URL.
  if (is.development) {
    window.loadURL(config.LOCAL_WEB_URL);
  } else {
    window.loadURL(config.PRODUCTION_WEB_URL);
  }

  // Po uruchomieniu aplikacji w trybie programistycznym, automatycznie nastąpi wyświetlenie panelu narzędzi.
  if (is.development) {
    window.webContents.openDevTools();
  }

  // Zdefiniowanie polityki CSP w środowisku produkcyjnym.
  if (!is.development) {
    setContentSecurityPolicy(`
    default-src 'none';
    script-src 'self';
    img-src 'self' https://www.gravatar.com;
    style-src 'self' 'unsafe-inline';
    font-src 'self';
    connect-src 'self' ${config.PRODUCTION_API_URL};
    base-uri 'none';
    form-action 'none';
    frame-ancestors 'none';
  `);
  }

  // Po zamknięciu okna należy wyzerować jego obiekt.
  window.on('closed', () => {
    window = null;
  });
}

// Gdy framework Electron będzie gotowy, należy utworzyć okno aplikacji.
app.on('ready', createWindow);

// Zakończenie działania po zamknięciu wszystkich okien.
app.on('window-all-closed', () => {
  // W systemie macOS zakończenie aplikacji musi być wyraźnie wymuszone.
  if (process.platform !== 'darwin') {
    app.quit();
  }
});

app.on('activate', () => {
  // W systemie macOS kliknięcie ikony aplikacji w Docku spowoduje wyświetlenie jej okna.
  if (window === null) {
    createWindow();
  }
});
