/**
 * 
 */
package com.apress.isf.spring.boot;

import javax.sql.DataSource;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;

/**
 * @author Felipe Gutierrez
 *
 */
@Configuration
@ImportResource("classpath:META-INF/spring/jdbc-context.xml")
public class JDBCConfig {

	@Bean
    public DataSource dataSource() {
        EmbeddedDatabaseBuilder builder = new EmbeddedDatabaseBuilder();
        EmbeddedDatabase db = builder.setType(EmbeddedDatabaseType.HSQL).
            addScript("META-INF/data/schema.sql").
            addScript("META-INF/data/data.sql").build();
        return db;
    }
	
	
}
