/**
 * 
 */
package com.apress.isf.spring.annotated.data;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Repository;

import com.apress.isf.java.model.Document;
import com.apress.isf.java.model.Type;
import com.apress.isf.spring.data.DocumentDAO;

/**
 * @author Felipe Gutierrez
 *
 */
@Repository("documentDAO")
public class AnnotatedDocumentRepository implements DocumentDAO {
	
	public Document[] getAll() {
		return storage();
	}
	
	private Document[] storage(){
		List<Document> result = new ArrayList<Document>();
		
		Type type = new Type();
		type.setName("PDF");
		type.setDesc("Portable Document Format");
		type.setExtension(".pdf");
		
		
		Document document = new Document();
		document.setName("Szablon ksiki");
		document.setType(type);
		document.setLocation("/Users/felipeg/Documents/Random/Szablon ksiazki.pdf");
		
		result.add(document);
		
		document = new Document();
		document.setName("Przykadowa umowa");
		document.setType(type);
		document.setLocation("/Users/felipeg/Documents/Contracts/Przykladowa umowa.pdf");
		
		result.add(document);
		
		type = new Type();
		type.setName("NOTE");
		type.setDesc("Notatki tekstowe");
		type.setExtension(".txt");
		
		document = new Document();
		document.setName("Clustering with RabbitMQ");
		document.setType(type);
		document.setLocation("/Users/felipeg/Documents/Random/Clustering with RabbitMQ.txt");
		
		result.add(document);
		
		type = new Type();
		type.setName("WEB");
		type.setDesc("cze sieciowe");
		type.setExtension(".url");
		
		document = new Document();
		document.setName("Pro Spring Security Book");
		document.setType(type);
		document.setLocation("http://www.apress.com/9781430248187");
		
		result.add(document);
		
		return result.toArray(new Document[result.size()]);
	}
}
