package {
	import flash.display.Sprite;	
	import flash.events.Event;
	
	public class BouncingBall3D extends Sprite {
		private var g:Number=0.1; // przyśpieszenie grawitacyjne
		private var vx:Number;  // początkowa pozioma składowa prędkości
		private var vy:Number;  // początkowa pionowa składowa prędkości
		private var vz:Number;  // boczna składowa prędkości
		private var ball:Ball;
		private var w:Number;
		private var gfac:Number=-0.99;
		private var wfac:Number=-0.99;

		public function BouncingBall3D() {
			init();
		}
		private function init():void {		
			vx = Math.random()*5;
			vy = (Math.random()-0.5)*4;
			vz = 4;
			ball = new Ball();	
			ball.x = 50;
			ball.y = 75;
			ball.z = 0;
			w = ball.width/2;
			addChild(ball);	
			addEventListener(Event.ENTER_FRAME,onEachTimestep); 
		}

		private function onEachTimestep(evt:Event):void{

			vy += g;      // grawitacja zwiększa pionową składową prędkości
			
			ball.x += vx; // prędkość pozioma zwiększa przemieszczenie ciała w poziomie
			ball.y += vy; // prędkość pionowa zwiększa przemieszczenie ciała w pionie
			ball.z += vz;
			
			if (ball.y > 350){ // w przypadku zderzenia z podłożem
				ball.y = 350;
				vy *= gfac;    // wektor prędkości pionowej ulega odwróceniu i skróceniu
			}
			if (ball.x > 550 - w){
				ball.x = 550 - w;
				vx *= wfac;
			}
			if (ball.x < w){
				ball.x = w;
				vx *= wfac;
			}
			if (ball.z > 200){
				ball.z = 200;
				vz *= wfac;
			}
			if (ball.z < -200){
				ball.z = -200;
				vz *= wfac;
			}
			//trace(ball.z);
			//trace(vz);

		}
	}
}





