package com.physicscodes.math {
	import flash.display.Sprite;
	import flash.text.TextField;

	public class Graph extends Sprite {
		// położenie początku układu (w pikselach) w dokumencie nadrzędnym
		private var x_orig:Number;
		private var y_orig:Number;
		// overall wdith and height of graph in pixels
		private var x_width:Number;
		private var y_width:Number;
		// wartości minimalna i maksymalna współrzędnych x i y względem początku układu
		private var x_min_rel:Number;
		private var x_max_rel:Number;
		private var y_min_rel:Number;
		private var y_max_rel:Number;
		// oczywiste
		private var x_tick_major:Number;
		private var x_tick_minor:Number;
		private var y_tick_major:Number;
		private var y_tick_minor:Number;
		// skalowanie niezbędne do wyświetlenia wartości na osiach
		private var x_displ_scal:Number;
		private var y_displ_scal:Number;
		// wysokość i szerokość pola tekstowego opisu osi
		// zmiany nie powinny być konieczne (mam nadzieję)
		private var tw:Number=25;
		private var th:Number=20;
		// deklaracje typów wykorzystywanych później zmiennych
		private var x_min:Number;
		private var x_max:Number;
		private var y_min:Number;
		private var y_max:Number;
		private var xx:Number;
		private var yy:Number;
		private var x_displ:Number;
		private var y_displ:Number;
		private var txpos:Number;
		private var typos:Number;
		private var mc:Sprite;
		// pola tekstowe
		private var xbox:TextField=new TextField ;
		private var ybox:TextField=new TextField ;		
		private var xtick:TextField ;
		private var ytick:TextField ;
		
     	public function Graph(xmin:Number=-5,xmax:Number=5,ymin:Number=-5,ymax:Number=5,						   
						   x0:Number=275,y0:Number=200,xwidth:Number=480,ywidth:Number=330) {		 
			mc=new Sprite;
			addChild(mc);
			
			x_orig=x0;
			y_orig=y0;
			x_width=xwidth;
			y_width=ywidth;
			
			x_displ_scal=(xmax-xmin)/xwidth;
			y_displ_scal=(ymax-ymin)/ywidth;		
			
			x_min_rel=xmin/x_displ_scal;
			x_max_rel=xmax/x_displ_scal;
			y_min_rel=ymin/y_displ_scal;
			y_max_rel=ymax/y_displ_scal;
			
			fconvert();
		}
				
		// rysuje główne i pomocnicze linie osi oraz wyświetla wartości
		public function drawgrid(xmajor:Number=1,xminor:Number=0.2,ymajor:Number=1,yminor:Number=0.2):void{
			x_tick_major=xmajor/x_displ_scal;
			x_tick_minor=xminor/x_displ_scal;
			y_tick_major=ymajor/y_displ_scal;
			y_tick_minor=yminor/y_displ_scal;
			drawminor();
			drawmajor();
			displayvalues();						
		}		
		
		// rysuje osi		
		public function drawaxes(xlabel:String="x",ylabel:String="y"):void{
			mc.graphics.lineStyle(2, 0x000000, 1);
			mc.graphics.moveTo(x_min,y_orig);
			mc.graphics.lineTo(x_max,y_orig);
			mc.graphics.moveTo(x_orig,y_min);
			mc.graphics.lineTo(x_orig,y_max);
			axislabels(xlabel,ylabel);
		}		
		
		// nanosi dane
		public function plot(xArr:Array, yArr:Array, pColor:uint, pDots:Boolean=true, pLine:Boolean=true):void{
			var xpos:Number=x_orig+xArr[0]/x_displ_scal;
			var ypos:Number=y_orig-yArr[0]/y_displ_scal;
			mc.graphics.lineStyle(1,pColor,1);
			mc.graphics.moveTo(xpos,ypos);
			mc.graphics.drawCircle(xpos,ypos,1);
			for (var i:int=1; i<xArr.length; i++){
				xpos=x_orig+xArr[i]/x_displ_scal;
				ypos=y_orig-yArr[i]/y_displ_scal;
				if (pLine){
					mc.graphics.lineTo(xpos,ypos);				
				}
				if (pDots){
					mc.graphics.drawCircle(xpos,ypos,1);
				}
			}
		}
		
 		// przekształca do układu współrzędnych bezwzględnych		
		private function fconvert():void{
			x_min=x_min_rel + x_orig;
			x_max=x_max_rel + x_orig;
			y_min=y_orig - y_min_rel;
			y_max=y_orig - y_max_rel;
			txpos=x_orig - tw;
			typos=y_orig;
		}		
		
		// rysuje główne linie osi		
		private function drawmajor():void{
			mc.graphics.lineStyle(1, 0x999999, 1);
			yy=y_max;
			do {
				mc.graphics.moveTo(x_min,yy);
				mc.graphics.lineTo(x_max,yy);
				yy+= y_tick_major;
			} while (yy <= y_min);
			xx=x_min;
			do {
				mc.graphics.moveTo(xx,y_min);
				mc.graphics.lineTo(xx,y_max);
				xx+= x_tick_major;
			} while (xx <= x_max);
		}
		
 		// rysuje pomocnicze linie osi		
		private function drawminor():void{
			mc.graphics.lineStyle(1, 0xcccccc, 1);
			yy=y_max;
			do {
				mc.graphics.moveTo(x_min,yy);
				mc.graphics.lineTo(x_max,yy);
				yy+= y_tick_minor;
			} while (yy <= y_min);
			xx=x_min;
			do {
				mc.graphics.moveTo(xx,y_min);
				mc.graphics.lineTo(xx,y_max);
				xx+= x_tick_minor;
			} while (xx <= x_max);
		}		
		
		// nanosi wartości		
		private function displayvalues():void{
			yy=y_max;
			var xtick:TextField ;
			do {
				xtick=new TextField;
				addChild(xtick);
				xtick.x=txpos;
				xtick.y=yy - th / 2;
				xtick.width=tw;
				xtick.height=th;
				xtick.autoSize="center";
				y_displ=(y_orig - yy) * y_displ_scal;
				xtick.text=String(y_displ);
				yy+= y_tick_major;
			} while (yy <= y_min);
			xx=x_min;
			do {
				ytick=new TextField;
				addChild(ytick);
				ytick.x=xx - tw + 10;
				ytick.y=typos;
				ytick.width=tw;
				ytick.height=th;
				ytick.autoSize="center";
				x_displ=(xx - x_orig) * x_displ_scal;
				ytick.text=String(x_displ);
				xx+= x_tick_major;
			} while (xx <= x_max);
		}
		
		// opisuje osi		
		private function axislabels(xlabel:String,ylabel:String):void{
			mc.addChild(xbox);
			mc.addChild(ybox);
			xbox.x=x_max + 0.75 * tw -10;
			xbox.y=typos - th / 2;
			xbox.width=tw;
			xbox.height=th;
			ybox.x=txpos + tw / 2;
			ybox.y=y_max - 1.5 * th;
			ybox.width=tw;
			ybox.height=th;
			xbox.autoSize="center";
			ybox.autoSize="center";
			xbox.text=xlabel;
			ybox.text=ylabel;
		}		
		
	}
}