package {
	import com.physicscodes.motion.ForcerRB3D;
	import com.physicscodes.motion.Forces3D;
	import com.physicscodes.objects.PolyhedronRB;
	import flash.geom.Vector3D;			
	import flash.events.MouseEvent;		

	public class RotatingRBCubeMover extends ForcerRB3D {
		private var _object:PolyhedronRB;
		private var _mass:Number;
		private var _g:Number = 0;
		private var _k:Number = 0.2; // współczynnik tłumienia prędkości kątowej		
		private var _tq:Vector3D = new Vector3D(0,0,0);		
		private var _tqMax:Vector3D = new Vector3D(10,10,10);

		public function RotatingRBCubeMover(pobject:PolyhedronRB):void {
			_object = pobject;
			_mass = _object.mass;
			_object.pos = new Vector3D(275,200,0);
			_object.stage.addEventListener(MouseEvent.MOUSE_DOWN,onDown);									
			super(_object);
		}
		override protected function calcForce():void {
			force = Forces3D.constantGravity(_mass,_g);
			torque = _tq;
			var vec:Vector3D = _object.angVelo;
			vec.scaleBy(-_k);
			torque = torque.add(vec);
		}

		override protected function moveObject():void{
			super.moveObject();
			updateObject();
		}

		private function updateObject():void{
			var vec:Vector3D = _object.angVelo;
			vec.scaleBy(dt);
			_object.updatePolyhedron(vec.x,vec.y,vec.z);
		}
		
		private function onDown(e:MouseEvent):void{
			_object.stage.addEventListener(MouseEvent.MOUSE_UP,onUp);
			_tq = _tqMax;
		}
		private function onUp(e:MouseEvent):void{
			_object.stage.removeEventListener(MouseEvent.MOUSE_UP,onUp);
			_tq = new Vector3D(0,0,0);
		}						
		
	}
}