﻿package com.physicscodes.objects {
	import flash.display.Sprite;
	import flash.geom.Vector3D;	
	import com.physicscodes.motion.Mover3D;
	
	public class Particle3D extends Sprite{
		// position: Particle inherits properties x, y, z from Sprite
		// size: Particle inherits properties width, height from Sprite
		
		// position components defined to Number precision
		private var _x:Number;
		private var _y:Number;
		private var _z:Number;
		// position vector
		private var _pos:Vector3D;
		// linear velocity components
		private var _vx:Number=0;
		private var _vy:Number=0;
		private var _vz:Number=0;
		// linear velocity vector
		private var _velo:Vector3D;
		// rotational velocity components in radians per second
		private var _omegax:Number=0;
		private var _omegay:Number=0;
		private var _omegaz:Number=0;
		// angular velocity vector
		//private var _omega:Vector3D;		
		// mass
		private var _mass:Number;
		// charge
		private var _charge:Number;	
		// lifetime and age
		private var _lifetime:Number=1e10;
		private var _age:Number=0;
		// for motion
		private var _mover:Mover3D;
		
		public function Particle3D(pmass:Number=1,pcharge:Number=0){
			_mass = pmass;
			_charge = pcharge;
		}
		// linear position components
		public function get xpos():Number{
			return _x;
		}
		public function set xpos(px:Number):void{
			_x = px;
			x = _x;
		}		
		public function get ypos():Number{
			return _y;
		}
		public function set ypos(py:Number):void{
			_y = py;
			y = _y;
		}
		public function get zpos():Number{
			return _z;
		}
		public function set zpos(pz:Number):void{
			_z = pz;
			z = _z;
		}
		// position vectors
		public function get pos():Vector3D{
			return new Vector3D(_x,_y,_z);
		}
		public function set pos(ppos:Vector3D):void{			
			_x = ppos.x;
			_y = ppos.y;
			_z = ppos.z;
			x = _x;
			y = _y;
			z = _z;
		}

		// linear velocity components
		public function get vx():Number{
			return _vx;
		}
		public function set vx(pvx:Number):void{
			_vx = pvx;
		}
		public function get vy():Number{
			return _vy;
		}
		public function set vy(pvy:Number):void{
			_vy = pvy;
		}
		public function get vz():Number{
			return _vz;
		}
		public function set vz(pvz:Number):void{
			_vz = pvz;
		}
		// vectors
		public function get velo():Vector3D{
			return new Vector3D(_vx,_vy,_vz);
		}
		
		public function set velo(pvelo:Vector3D):void{
			_vx = pvelo.x;
			_vy = pvelo.y;
			_vz = pvelo.z;			
		}
		
		// angular velocity components
		public function get omegax():Number{
			return _omegax;
		}
		public function set omegax(pomegax:Number):void{
			_omegax = pomegax;
		}
		
		public function get omegay():Number{
			return _omegay;
		}
		public function set omegay(pomegay:Number):void{
			_omegay = pomegay;
		}
		
		public function get omegaz():Number{
			return _omegaz;
		}
		public function set omegaz(pomegaz:Number):void{
			_omegaz = pomegaz;
		}
		
		// angular velocity vector
		public function get angVelo():Vector3D{
			return new Vector3D(_omegax,_omegay,_omegaz);
		}
		public function set angVelo(pomega:Vector3D):void{
			_omegax = pomega.x;
			_omegay = pomega.y;
			_omegaz = pomega.z;
		}			
		
		//---------------------------------------------------------
		// SCALARS
		public function get mass():Number{
			return _mass;
		}
		public function set mass(pmass:Number):void{
			_mass = pmass;
		}	
		public function get charge():Number{
			return _charge;
		}
		public function set charge(pcharge:Number):void{
			_charge = pcharge;
		}		
		public function get lifetime():Number{
			return _lifetime;
		}
		public function set lifetime(plifetime:Number):void{
			_lifetime = plifetime;
		}		
		public function get age():Number{
			return _age;
		}
		public function set age(page:Number):void{
			_age = page;
		}				

		public function move(ptimestep:Number=20,psteps:Number=0):void{		
			_mover = new Mover3D(this);
			_mover.startTime(ptimestep,psteps);			
		}
		public function pause():void{
			if (_mover){
				_mover.stopTime();
			}
		}		
		public function resume():void{
			if (_mover){			
				_mover.startTime();
			}
		}		
		public function stop():void{
			if (_mover){
				_mover.killTime();
				_mover = null;
			}
		}			
		/*
		public function clone():Particle3D {
			return new Particle3D(_mass,_charge);
		}
		*/
	}
}