﻿package{
	import flash.display.Shape;	
	import flash.display.Sprite;
	import flash.geom.Vector3D;		
	import flash.geom.Point;
	import com.physicscodes.objects.PolyhedronRB;

	public class Airplane extends Sprite{
		private var _airplane:PolyhedronRB;
		private var _vertices:Vector.<Vector3D>=new Vector.<Vector3D>();
		private var _faces:Vector.<Array>=new Vector.<Array>();
		private var _facesColors:Array;			
		//private var _h:Number = 90;
		private var _h:Number = 20;
		private var _fl:Number = 200;		
		private var _cm:Vector3D = new Vector3D(400,600,0);
		private var _im:Vector3D = new Vector3D(300000,100000,200000);	
	
		public function Airplane():void{
			makeRunway();
			init();
		}
		private function init():void{
			var h:Number = _h;			
/*			
			_vertices[0] = new Vector3D(h,0,0);
			_vertices[1] = new Vector3D(-h/2,0,-h/2);
			_vertices[2] = new Vector3D(-h/2,0,h/2);	
			_vertices[3] = new Vector3D(2*h/3,0,0);	
			_vertices[4] = new Vector3D(-h/2,0,h/4);							
			_vertices[5] = new Vector3D(-h/2,0,-h/4);
			_vertices[6] = new Vector3D(-h/2,-h/3,0);			
			_faces[0] = [0,1,2];
			_faces[1] = [3,4,6];			
			_faces[2] = [3,5,6];			
			_faces[3] = [6,5,4];					
			_facesColors = [0xFFFFCC,0x00FF66,0x00FF66,0x990000];
*/
			_vertices[0] = new Vector3D(-4*h,-h/2,-h);
			_vertices[1] = new Vector3D(4*h,-h/2,-h);
			_vertices[2] = new Vector3D(4*h,-h/2,h);
			_vertices[3] = new Vector3D(-4*h,-h/2,h);
			_vertices[4] = new Vector3D(-4*h,h/2,-h);
			_vertices[5] = new Vector3D(4*h,h/2,-h);
			_vertices[6] = new Vector3D(4*h,h/2,h);
			_vertices[7] = new Vector3D(-4*h,h/2,h);
			_faces[0] = [0,4,5,1];
			_faces[1] = [1,5,6,2];
			_faces[2] = [2,6,7,3];
			_faces[3] = [3,7,4,0];
			_faces[4] = [4,5,6,7];
			_faces[5] = [0,1,2,3];			
			_facesColors = [0x0000ff,0x666666,0x0000ff,0x333333,0x999999,0xcccccc];	

			_airplane = new PolyhedronRB(_fl,_cm,_im,_vertices,_faces,_facesColors);
			_airplane.mass = 30000;
			_airplane.pos = _airplane.centerOfMass;
			_airplane.velo = new Vector3D(0,0,0);
			addChild(_airplane);
			
			var mover:AirplaneMover = new AirplaneMover(_airplane);
			mover.startTime();
		}

		private function makeRunway():void{
			var road:Road = new Road(400,2000,0xcccccc,1);
			road.x = 400;
			road.y = 600;
			road.z = 0;
			road.rotationX = -90;
			addChild(road);			
		}
		
	}
}