package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.objects.Wall;
	import com.physicscodes.math.Vector2D;
	import flash.events.Event;
	import flash.events.MouseEvent;		
	
	public class InclinedWallBouncer2 extends Forcer{
		private var _ball:Ball;
		private var _wall:Wall;
		private var _g:Number=100;
		private var _vfac:Number=0.6;
		
		public function InclinedWallBouncer2(pball:Ball, pwall:Wall) :void{
			_ball = pball;			
			_wall = pwall;
			_ball.stage.addEventListener(MouseEvent.MOUSE_DOWN,onDown);			
			super(_ball);
		}	
		
		private function onDown(e:MouseEvent):void{
			_ball.velo2D = new Vector2D(0,0);
			_ball.stage.addEventListener(MouseEvent.MOUSE_UP,onUp);
			_ball.radius = 1;		
			_ball.xpos = _ball.stage.mouseX;
			_ball.ypos = _ball.stage.mouseY;	
			_ball.stage.addEventListener(Event.ENTER_FRAME,onEachFrame); 
			stopTime();			
		}
		private function onUp(e:MouseEvent):void{
			_ball.stage.removeEventListener(MouseEvent.MOUSE_UP,onUp);
			_ball.stage.removeEventListener(Event.ENTER_FRAME,onEachFrame); 			
			
			var wdir:Vector2D = _wall.dir;			   
		    var ballp1:Vector2D = _wall.p1.subtract(_ball.pos2D);
			var proj1:Number = ballp1.projection(wdir);                
			var dist:Vector2D = ballp1.addScaled(wdir.unit(), proj1*(-1));   
			if (dist.dotProduct(_wall.normal) < 0){
				_wall.side = -1;
			}else{
				_wall.side = 1;
			}
			startTime();			
		}		
		
		private function onEachFrame(e:Event):void{
			var dvec:Vector2D = new Vector2D(_ball.stage.mouseX-_ball.xpos,_ball.stage.mouseY-_ball.ypos);
			_ball.radius = dvec.length;			
		}
		
		override protected function moveObject():void{
			super.moveObject();
			checkBounce();
		}
	
		override protected function calcForce():void{
			force = Forces.constantGravity(_ball.mass,_g);
		}

		private function checkBounce():void{
			// wektor równoległy do ściany
			var wdir:Vector2D = _wall.dir;
			// wektory od kulki do końców ściany
		    var ballp1:Vector2D = _wall.p1.subtract(_ball.pos2D);
			var ballp2:Vector2D = _wall.p2.subtract(_ball.pos2D);
			// rzut obliczonych wektorów na wektor ściany
			var proj1:Number = ballp1.projection(wdir);                
			var proj2:Number = ballp2.projection(wdir);
			// wektor odległości ciała od ściany (prostopadły do ściany)
			var dist:Vector2D = ballp1.addScaled(wdir.unit(), proj1*(-1));
			// wykrywanie zderzenia
			var test:Boolean = ((Math.abs(proj1) < wdir.length) && (Math.abs(proj2) < wdir.length));
			
			var testTunneling:Boolean;				
		  	if (_wall.side*dist.dotProduct(_wall.normal) < 0){
				testTunneling = true;
			}else{
				testTunneling = false;
			}
			if (dist.dotProduct(_wall.normal) > 0){
				_wall.side = 1;
			}else{
				_wall.side = -1;
			}
			
			if (( (dist.length < _ball.radius) || (testTunneling) ) &&  test){
				// kąt pomiędzy prędkością a ścianą
				var angle:Number = Vector2D.angleBetween(_ball.velo2D, wdir);
				// przesunięcie ciała
				var normal:Vector2D = _wall.normal;
				if (normal.dotProduct(_ball.velo2D) > 0){
					normal.scaleBy(-1);
				}
				var deltaS:Number = (_ball.radius+dist.dotProduct(normal))/Math.sin(angle);
				var displ:Vector2D = _ball.velo2D.para(deltaS);
				_ball.pos2D = _ball.pos2D.subtract(displ);			
				// współczynnik korekcji prędkości
				var vcor:Number = 1-acc.dotProduct(displ)/_ball.velo2D.lengthSquared;
				// skorygowana prędkość przed zderzeniem 
				var Velo:Vector2D = _ball.velo2D.multiply(vcor);
				// prostopadła do ściany składowa wektora prędkości tuż przed zderzeniem
				var normalVelo:Vector2D = dist.para(Velo.projection(dist));
				// składowa prędkości równoległa do ściany; nie ulega zmianie w czasie zderzenia
				var tangentVelo:Vector2D = Velo.subtract(normalVelo);
				// prostopadła do ściany składowa prędkości tuż po zderzeniu
				_ball.velo2D = tangentVelo.addScaled(normalVelo,-_vfac);
	   		}
			// zderzenia przy granicach ścian
			else if (Math.abs(ballp1.length) < _ball.radius){
				bounceOffEndpoint(_wall.p1);
			}
			else if (Math.abs(ballp2.length) < _ball.radius){
				bounceOffEndpoint(_wall.p2);
			}
			
			if (testTunneling){
				_wall.side *= -1;
			}
		}
		
		private function bounceOffEndpoint(pEndpoint:Vector2D):void{
			var distp:Vector2D = _ball.pos2D.subtract(pEndpoint);
			// przesuwa cząstkę tak, by stykała się z końcem ściany			
			var L:Number = _ball.radius-distp.length;
			var vrel:Number = _ball.velo2D.length;
			_ball.pos2D = _ball.pos2D.addScaled(_ball.velo2D,-L/vrel);
			// składowa normalna prędkości przed zderzeniem
			var normalVelo:Vector2D = _ball.velo2D.project(distp);
			// styczna składowa prędkości
			var tangentVelo:Vector2D = _ball.velo2D.subtract(normalVelo);
			// składowa normalna prędkości po zderzeniu
			normalVelo.scaleBy(-_vfac);
			// prędkość końcowa po zderzeniu
			_ball.velo2D = normalVelo.add(tangentVelo);			
		}
	}
}