package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;

	public class Orbiter extends Forcer{
		
		private var _orbiter:Particle;				
		private var _massOrbiter:Number;
		private var _massAttractor:Number;		
		private var _center:Vector2D;
		private var _G:Number;

		public function Orbiter(porbiter:Particle,pattractor:Particle,pG:Number):void{
			_orbiter = porbiter;
			_massOrbiter = porbiter.mass;			
			_massAttractor = pattractor.mass;			
			_center = pattractor.pos2D;
			_G = pG;
			super(porbiter);
		}	
		
		override protected function calcForce():void{
			force = Forces.gravity(_G,_massAttractor,_massOrbiter,_orbiter.pos2D.subtract(_center));		
		}
	}
}
