package com.physicscodes.motion{	
	import com.physicscodes.motion.Mover;
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.motion.Forces;

	public class ForcerIntegrator extends Mover{
		private var _particle:Particle;
		private var _force:Vector2D;
		private var _acc:Vector2D;	
		private var _oldpos:Vector2D; 	// potrzebne w standardowej metodzie Verlet
		private var _olddt:Number;		// jak wyżej
		private var _n:uint=0;			// jak wyżej

		public function ForcerIntegrator(pparticle:Particle):void{
			_particle = pparticle;
			super(pparticle);
		}	
		
		public function get force():Vector2D {
			return _force;
		}			
		
		public function set force(pforce:Vector2D):void {
			_force = pforce;
		}

		override protected function moveObject():void{
			// wybierz jedną z metod, pozostałe oznacz komentarzem
			EulerExplicit();
			//EulerSemiImplicit();
			//EulerSemiImplicit2();
			//RK2();
			//RK4();			
			//PositionVerlet();
			//VelocityVerlet();
		}				
		
		protected function calcForce(ppos:Vector2D,pvel:Vector2D):void{
			_force = Forces.zeroForce();
		}

		private function getAcc(ppos:Vector2D,pvel:Vector2D):Vector2D{
			calcForce(ppos,pvel);
			return _force.multiply(1/_particle.mass);
		}

		private function EulerExplicit():void{			
			_acc = getAcc(_particle.pos2D,_particle.velo2D); 
			_particle.pos2D = _particle.pos2D.addScaled(_particle.velo2D,dt);
			_particle.velo2D = _particle.velo2D.addScaled(_acc,dt);			
		}
		
		private function EulerSemiImplicit():void{			
			_acc = getAcc(_particle.pos2D,_particle.velo2D); 
			_particle.velo2D = _particle.velo2D.addScaled(_acc,dt);			
			_particle.pos2D = _particle.pos2D.addScaled(_particle.velo2D,dt);			
		}
		
		private function EulerSemiImplicit2():void{			
			_particle.pos2D = _particle.pos2D.addScaled(_particle.velo2D,dt);					
			_acc = getAcc(_particle.pos2D,_particle.velo2D); 
			_particle.velo2D = _particle.velo2D.addScaled(_acc,dt);			
		}		
		
		private function PositionVerlet():void{			
			var temp:Vector2D = _particle.pos2D; // przechowuje dane o bieżącym położeniu w zmiennej pomocniczej
			if (_n==0){ // inicjuje zmienne poprzedniego położenia i poprzedniego kroku czasowego
				_acc = getAcc(_particle.pos2D,_particle.velo2D); 
//				_oldpos = _particle.pos2D.addScaled(_particle.velo2D,-dt).addScaled(_acc,dt*dt/2);				
				_oldpos = _particle.pos2D.addScaled(_particle.velo2D,-dt);
				_olddt = dt;
			}
			_acc = getAcc(_particle.pos2D,_particle.velo2D); // wyznacza przyśpieszenie na podstawie bieżących prędkości i położenia
			_particle.pos2D = _particle.pos2D.addScaled(_particle.pos2D.subtract(_oldpos),dt/_olddt).addScaled(_acc,dt*dt); // aktualizuje wartość położenia
			//_particle.pos2D = _particle.pos2D.add(_particle.pos2D).subtract(_oldpos).addScaled(_acc,dt*dt); // bez korekcji czasu
			_particle.velo2D = (_particle.pos2D.subtract(_oldpos)).multiply(0.5/dt);	// szacuje nową prędkość					
			_oldpos = temp; // przechowuje wartość zmiennej pos sprzed aktualizacji; w następnym kroku obliczeniowym będzie to stara wartość położenia
			_olddt = dt;
			_n++;
		}
		
		private function VelocityVerlet():void{			
			_acc = getAcc(_particle.pos2D,_particle.velo2D); // wyznacza przyśpieszenie na podstawie bieżących prędkości i położenia
			var accPrev:Vector2D = _acc; // zapisuje wartość prędkości do dalszych obliczeń
			_particle.pos2D = _particle.pos2D.addScaled(_particle.velo2D,dt).addScaled(_acc,dt*dt/2); // aktualizuje wartość położenia
			_acc = getAcc(_particle.pos2D,_particle.velo2D); // wartość przyśpieszenia na podstawie zaktualizowanych położeń; zakładamy, że siłą nie zależy jawnie od prędkości
			_particle.velo2D = _particle.velo2D.addScaled(_acc.add(accPrev),dt/2);	// aktualizuje położenie		
		}		

		private function RK2():void{			
			// krok 1
			var pos1:Vector2D = _particle.pos2D;
			var vel1:Vector2D = _particle.velo2D;
			var acc1:Vector2D = getAcc(pos1,vel1); 
			// krok 2
			var pos2:Vector2D = pos1.addScaled(vel1,dt); 
			var vel2:Vector2D = vel1.addScaled(acc1,dt);
			var acc2:Vector2D = getAcc(pos2,vel2); 
			// aktualizuje prędkość i położenie cząstki
			_particle.pos2D = pos1.addScaled(vel1.add(vel2),dt/2);
			_particle.velo2D = vel1.addScaled(acc1.add(acc2),dt/2);			
			//_acc = acc1.add(acc2).multiply(1/2); 			 
		}

		private function RK4():void{			
			// krok 1
			var pos1:Vector2D = _particle.pos2D;
			var vel1:Vector2D = _particle.velo2D;
			var acc1:Vector2D = getAcc(pos1,vel1); 
			// krok 2
			var pos2:Vector2D = pos1.addScaled(vel1,dt/2); 
			var vel2:Vector2D = vel1.addScaled(acc1,dt/2);
			var acc2:Vector2D = getAcc(pos2,vel2); 
			// krok 3
			var pos3:Vector2D = pos1.addScaled(vel2,dt/2); 
			var vel3:Vector2D = vel1.addScaled(acc2,dt/2);
			var acc3:Vector2D = getAcc(pos3,vel3); 
			// krok 4
			var pos4:Vector2D = pos1.addScaled(vel3,dt); 
			var vel4:Vector2D = vel1.addScaled(acc3,dt);
			var acc4:Vector2D = getAcc(pos4,vel4); 
			// sumuje vel i acc
			var velsum:Vector2D = vel1.addScaled(vel2,2).addScaled(vel3,2).add(vel4);
			var accsum:Vector2D = acc1.addScaled(acc2,2).addScaled(acc3,2).add(acc4);
			// aktualizuje prędkość i położenie cząstki
			_particle.pos2D = pos1.addScaled(velsum,dt/6);
			_particle.velo2D = vel1.addScaled(accsum,dt/6);			
			//_acc = accsum.multiply(1/6);
		}
	
	}
	
}