package {
	import com.physicscodes.math.Graph;
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.motion.MultiForcer2;
	import com.physicscodes.objects.Particle;
	import com.physicscodes.objects.Star;			

	public class LongRangeMover extends MultiForcer2{
										
		private var _particles:Array;			
		private var _attractor:Star;
		private var _massAttractor:Number;		
		private var _center:Vector2D;
		private var _G:Number = 10;		
		private var _graph:Graph;		
		private var _stageWidth:Number;
		private var _stageHeight:Number;		
		private var _cols:Array = new Array();
		//private var _eps:Number = 10;
		//private var _rmin:Number = 100;		
		
		public function LongRangeMover(pparticles:Array,pattractor:Star):void{		
			_massAttractor = pattractor.mass;			
			_center = pattractor.pos2D;
			_particles = pparticles;
			_attractor = pattractor;
			_stageWidth = pattractor.stage.stageWidth;			
			_stageHeight = pattractor.stage.stageHeight;		
			setupCols();
			setupGraph();			
			super(pparticles);
		}	
		
		override protected function calcForce(pparticle:Particle,pnum:uint):void{
			var radius:Vector2D=pparticle.pos2D.subtract(_center);		
			var gravityCentral:Vector2D;
			if (radius.length < _attractor.radius) {
				gravityCentral = new Vector2D(0,0);
			}
			else{
				gravityCentral = Forces.gravity(_G,_massAttractor,pparticle.mass,radius);		
			}
			force = gravityCentral;
			
			/*
			var gravityMutual:Vector2D = new Vector2D(0,0);
			for (var i:uint=0; i<_particles.length; i++){
				if (i != pnum){
					var particle:Particle = _particles[i];
					var radiusP:Vector2D = pparticle.pos2D.subtract(particle.pos2D);		
					if (radiusP.length < _rmin){
						var gravityP:Vector2D = Forces.gravityModified(_G,particle.mass,pparticle.mass,radiusP,_eps);	
						gravityMutual.incrementBy(gravityP);
					}
				}
			}
			force = gravityMutual;		
			//force = Forces.add([gravityCentral, gravityMutual]);			
			*/
			
			plotGraph(pparticle,_cols[pnum]);		
		}
		
		private function setupCols():void{
			for (var i:uint=0; i<_particles.length; i++){
				_cols.push(0xffffff*Math.random());
			}
		}
		
		private function setupGraph():void {
			//_graph= new Graph(xmin,xmax,ymin,ymax,xorig,yorig,xwidth,ywidth);	
			_graph= new Graph(0,_stageWidth,0,_stageHeight,0,0,_stageWidth,_stageHeight);						
			_attractor.stage.addChild(_graph);
		}
		private function plotGraph(pparticle:Particle,pcol:uint):void{
			_graph.plot([pparticle.xpos], [-pparticle.ypos], pcol, false, true);		
		}			
		
	}
}
