﻿package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.math.Graph;
	
	public class FreeOscillator2 extends Forcer{
		private var _object:Ball;
		private var _center:Vector2D;
		private var _displ:Vector2D;
		private var _kSpring:Number=1;		
		private var _graphX:Graph;
		private var _graphY:Graph;		
		private var _omega:Number;
		private var _A:Vector2D;
		private var _B:Vector2D;

		public function FreeOscillator2(pobject:Ball,pattractor:Ball):void{
			_object = pobject;
            _center = pattractor.pos2D;
			_omega = Math.sqrt(_kSpring/_object.mass);
			_A = _object.pos2D.subtract(_center);
			_B = _object.velo2D.multiply(1/_omega);
			setupGraph();
			super(_object);
		}
		
		override protected function moveObject():void{		
			super.moveObject();		
			plotGraph();
		}		
			
		override protected function calcForce():void{
            _displ=_object.pos2D.subtract(_center);
			force = Forces.spring(_kSpring,_displ);	
		}
		
		// create displacement-time graphs		
		private function setupGraph():void {
			//_graph= new Graph(xmin,xmax,ymin,ymax,xorig,yorig,xwidth,ywidth);	
			_graphX= new Graph(0,20,-250,250,50,200,450,100);					
			_graphX.drawgrid(5,1,250,50);			
			_graphX.drawaxes('time (s)','x displacement (px)');	
			_object.stage.addChild(_graphX);
			_graphY= new Graph(0,20,-250,250,50,375,450,100);					
			_graphY.drawgrid(5,1,250,50);			
			_graphY.drawaxes('time (s)','y displacement (px)');	
			_object.stage.addChild(_graphY);			
		}
		private function plotGraph():void{
			_graphX.plot([time], [_displ.x], 0xff0000, false, true);
			_graphY.plot([time], [_displ.y], 0x0000ff, false, true);
			var r:Vector2D = _A.multiply(Math.cos(_omega*time)).add(_B.multiply(Math.sin(_omega*time)));			
			_graphX.plot([time], [r.x], 0x00ff00, false, true);
			_graphY.plot([time], [r.y], 0xff00ff, false, true);			
		}	
	}
}