package {
	import com.physicscodes.motion.ForcerRB3D;
	import com.physicscodes.motion.Forces3D;
	import com.physicscodes.objects.PolyhedronRB;
	import flash.geom.Vector3D;			
	import flash.events.MouseEvent;		

	public class RotatingRBCubeMover2 extends ForcerRB3D {
		private var _object:PolyhedronRB;
		private var _mass:Number;
		private var _g:Number = 0;
		private var _k:Number = 0.2; // współczynnik tłumienia prędkości kątowej		
		private var _tq:Vector3D = new Vector3D(0,0,0);		

		public function RotatingRBCubeMover2(pobject:PolyhedronRB):void {
			_object = pobject;
			_mass = _object.mass;
			_object.pos = new Vector3D(275,200,0);
			_object.stage.addEventListener(MouseEvent.MOUSE_DOWN,onDown);									
			super(_object);
		}
		override protected function calcForce():void {
			force = Forces3D.constantGravity(_mass,_g);
			torque = _tq;
			var vec:Vector3D = _object.angVelo;
			vec.scaleBy(-_k);
			torque = torque.add(vec);
		}

		override protected function moveObject():void{
			super.moveObject();
			updateObject();
		}

		private function updateObject():void{
			var vec:Vector3D = _object.angVelo;
			vec.scaleBy(dt);
			_object.updatePolyhedron(vec.x,vec.y,vec.z);
		}
		
		private function onDown(e:MouseEvent):void{
			_object.stage.addEventListener(MouseEvent.MOUSE_UP,onUp);
			_object.stage.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
			onMove(e);
		}
		
		private function onMove(e:MouseEvent):void{
			var xp:Number = _object.xpos;
			var yp:Number = _object.ypos;			
			var xm:Number = _object.stage.mouseX;
			var ym:Number = _object.stage.mouseY;
			
			var xtorque:Number = 10*(xm - xp)/xp;
			var ytorque:Number = 10*(ym - yp)/yp;			
			_tq = new Vector3D(xtorque,ytorque,0);
		}
		
		private function onUp(e:MouseEvent):void{
			_object.stage.removeEventListener(MouseEvent.MOUSE_UP,onUp);
			_object.stage.removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
			_tq = new Vector3D(0,0,0);
		}	
		
		
	}
}