﻿package {
	import com.physicscodes.motion.Mover;		
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;

	public class SatelliteOrbiter2 extends Mover{	
		private var _orbiter:Particle;				
		private var _omega:Number;
		private var _r:Number;
		private var _x0:Number;
		private var _y0:Number;	
		private var _G:Number=1;

		public function SatelliteOrbiter2(porbiter:Particle,pattractor:Particle):void{
			_orbiter = porbiter;
			_r = _orbiter.pos2D.subtract(pattractor.pos2D).length;
			_x0 = pattractor.xpos;
			_y0 = pattractor.ypos;
			_omega = Math.sqrt(_G*pattractor.mass/(_r*_r*_r));			
			super(porbiter);
			//trace(Math.pow(_G*pattractor.mass/(pattractor.angVelo*pattractor.angVelo),1/3));
		}	

		override protected function moveObject():void {	
			_orbiter.pos2D = new Vector2D(_r*Math.cos(_omega*time)+_x0,_r*Math.sin(_omega*time)+_y0);						
		}		
		
	}
}
