package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;
	import flash.display.Sprite;

	public class ObliqueMover extends Forcer{
		private var _particle:Particle;		
		private var _angle:Number;			
		private var _g:Number=10;
		private var _ck:Number=0.2;
		private var _cs:Number=0.25;	
		private var _vtol:Number=0.000001;

		public function ObliqueMover(pparticle:Particle,pangle:Number):void{		
			_particle = pparticle;					
			_angle = pangle;
			super(pparticle);
		}	
	
		override protected function calcForce():void{
			var gravity:Vector2D = Forces.constantGravity(_particle.mass,_g);
			var normal:Vector2D = Vector2D.vector2D(_particle.mass*_g*Math.cos(_angle),0.5*Math.PI-_angle,false);
			var coeff:Number;
			if (_particle.velo2D.length < _vtol){  // tarcie statyczne
				coeff = Math.min(_cs*normal.length,_particle.mass*_g*Math.sin(_angle)); 
			}else{  // tarcie kinetyczne
				coeff = _ck*normal.length; 
			}
//			trace(_particle.velo2D.length);			
			var friction:Vector2D = normal.perp(coeff);						
			force = Forces.add([gravity, normal, friction]);		
		}
	}
}
