﻿package {
	import com.physicscodes.math.Graph;
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.motion.ForcerIntegrator;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.objects.Particle;			

	public class Oscillator extends ForcerIntegrator{
		private var _particle:Particle;					
		private var _center:Vector2D;
		private var _graph:Graph;		
		private var _stageWidth:Number;
		private var _stageHeight:Number;		
		private var _k:Number = 1;

		public function Oscillator(porbiter:Particle,pattractor:Particle):void{
			_particle = porbiter;		
			_center = pattractor.pos2D;
			_stageWidth = _particle.stage.stageWidth;			
			_stageHeight = _particle.stage.stageHeight;				
			setupGraph();		
			super(porbiter);
		}	
		
		override protected function calcForce(ppos:Vector2D,pvel:Vector2D):void{
			force = Forces.spring(_k,ppos.subtract(_center));	
		}
	
		override protected function moveObject():void{
			super.moveObject();
			plotGraph();		
		}	
		
		private function setupGraph():void {
			//_graph= new Graph(xmin,xmax,ymin,ymax,xorig,yorig,xwidth,ywidth);	
			_graph= new Graph(0,_stageWidth,0,_stageHeight,0,0,_stageWidth,_stageHeight);						
			_particle.stage.addChild(_graph);
		}
		private function plotGraph():void{
			_graph.plot([_particle.xpos], [-_particle.ypos], 0xcccccc, false, true);		
		}				
		
	}
}
