package {
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.motion.MultiMover;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.objects.Wall;
	
	public class MoleculesCollider extends MultiMover{
		private var _balls:Array;
		private var _walls:Array;
		private var _vfac:Number=1;				
		
		public function MoleculesCollider(pballs:Array,pwalls:Array) :void{
			_balls = pballs;
			_walls=pwalls;
			super(_balls);
		}	
		  
		override protected function moveObject():void{
			super.moveObject();		
			checkCollision()	
		}		  
		  
		private function checkCollision():void{
			for (var i:uint=0; i<_balls.length; i++){
				var ball1:Ball = _balls[i];
				for(var j:uint=i+1; j<_balls.length; j++){
					var ball2: Ball = _balls[j];
					var dist:Vector2D = ball1.pos2D.subtract(ball2.pos2D);
					if (dist.length < (ball1.radius +ball2.radius) ) {   
						// wektory normalne prędkości tuż przed zderzeniem
						var normalVelo1:Vector2D = ball1.velo2D.project(dist);
						var normalVelo2:Vector2D = ball2.velo2D.project(dist);			
						// styczne wektoy prędkości
						var tangentVelo1:Vector2D = ball1.velo2D.subtract(normalVelo1);
						var tangentVelo2:Vector2D = ball2.velo2D.subtract(normalVelo2);
						// przemieszcza cząstki tak, by stykały się jedynie powierzchniami
						var L:Number = ball1.radius +ball2.radius-dist.length;
						var vrel:Number = normalVelo1.subtract(normalVelo2).length;
						ball1.pos2D = ball1.pos2D.addScaled(normalVelo1,-L/vrel);
						ball2.pos2D = ball2.pos2D.addScaled(normalVelo2,-L/vrel);			
						// prostopadłe składowe wektorów prędkości po zderzeniu
						var m1:Number = ball1.mass;
						var m2:Number = ball2.mass;
						var u1:Number = normalVelo1.projection(dist);
						var u2:Number = normalVelo2.projection(dist);			
						var v1:Number = ((m1-m2)*u1+2*m2*u2)/(m1+m2);
						var v2:Number = ((m2-m1)*u2+2*m1*u1)/(m1+m2);
						// normalne wektory prędkości po zderzeniu
						normalVelo1 = dist.para(v1);
						normalVelo2 = dist.para(v2);
						// wektory prędkości końcowych po zderzeniu
						ball1.velo2D = normalVelo1.add(tangentVelo1);
						ball2.velo2D = normalVelo2.add(tangentVelo2);
					}
				}
				checkWallBounce(ball1);
			}
		}
		
		private function checkWallBounce(pball:Ball):void{
			var hasHitAWall:Boolean = false;		
			for (var i:int=0; (i<_walls.length && hasHitAWall==false); i++){
				var wall:Wall = _walls[i];			
				var wdir:Vector2D = wall.dir;			   
		    	var ballp1:Vector2D = wall.p1.subtract(pball.pos2D);
				var ballp2:Vector2D = wall.p2.subtract(pball.pos2D);
				var proj1:Number = ballp1.projection(wdir);                
				var proj2:Number = ballp2.projection(wdir);
				var dist:Vector2D = ballp1.addScaled(wdir.unit(), proj1*(-1));
				var test:Boolean=((Math.abs(proj1) < wdir.length) && (Math.abs(proj2) < wdir.length));
				if ((dist.length < pball.radius) &&  test){
					var angle:Number = Vector2D.angleBetween(pball.velo2D, wdir);
					var normal:Vector2D = wall.normal;
					if (normal.dotProduct(pball.velo2D) > 0){
						normal.scaleBy(-1);
					}
					var deltaS:Number = (pball.radius+dist.dotProduct(normal))/Math.sin(angle);					
					var displ:Vector2D = pball.velo2D.para(deltaS);
					pball.pos2D = pball.pos2D.subtract(displ);			
					var normalVelo:Vector2D = pball.velo2D.project(dist);
					var tangentVelo:Vector2D = pball.velo2D.subtract(normalVelo);
					pball.velo2D = tangentVelo.addScaled(normalVelo,-_vfac);					
					hasHitAWall = true;
			   	}
			}                   
		}
		
	}
}