package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;

	public class Flyer extends Forcer{
		
		private var _particle:Particle;		
		private var _g:Number=10;
		private var _kDrag:Number=0.01;
		private var _kLift:Number=0.5;		
		private var _magThrust:Number=5;
		private var _groundLevel:Number=750;

		public function Flyer(pparticle:Particle):void{
			_particle = pparticle;				
			super(pparticle);
		}		

		override protected function calcForce():void{
			var gravity:Vector2D = Forces.constantGravity(_particle.mass,_g);
			var velX:Vector2D = new Vector2D(_particle.vx,0);
			var drag:Vector2D = Forces.drag(_kDrag,velX);
			var lift:Vector2D = Forces.lift(_kLift,velX);
			var thrust:Vector2D = new Vector2D(_magThrust,0);
			var normal:Vector2D;
			if (_particle.y >= _groundLevel){
				normal = gravity.multiply(-1);
			}else{
				normal = new Vector2D(0,0);
			}
			force = Forces.add([gravity, drag, lift, thrust, normal]);		
		}
	}
}
