package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;
	import flash.text.TextField;	
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;	

	public class SubmarineMover extends Forcer{
		private var _sub:Particle;		
		private var _g:Number=10;
		private var _rho:Number=1; // gęstość wody
		private var _V:Number=1;
		private var _k:Number=0.05;
		private var _yLevel:Number=200;
		private var _thrustMag:Number=20;
		private var _thrust:Vector2D = new Vector2D(0,0);
		private var _txt:TextField;
		private var _rotate:Boolean = false;
		private var _waterHeight:Number;		
		private var _waterMass:Number = 1;
		private var _emptySubMass:Number = 0.5;
		private var _waterFraction:Number = 0.4; // musi przyjmować wartość z zakresu od 0 do 1
		private var _ballastInc:Number=0; // zwiększenie balastu		
		private var _incMag:Number = 0.01; // jednostka zwiększania balastu
			
		public function SubmarineMover(pparticle:Particle,ptxt:TextField):void{
			_sub = pparticle;		
			_txt = ptxt;
			super(pparticle);
			initSetup();
		}	
		
		private function initSetup():void{
			_waterHeight = _sub.water.height;
			setWater();
			_sub.stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownListener);
//			_sub.stage.addEventListener(KeyboardEvent.KEY_UP, keyUpListener);			
		}
		
		private function keyDownListener(e:KeyboardEvent):void {
			if (e.keyCode == Keyboard.RIGHT) {
				_thrust = new Vector2D(_thrustMag,0);
				_rotate = true;
			} else if (e.keyCode == Keyboard.LEFT) {
				_thrust = new Vector2D(-_thrustMag,0);
				_rotate = true;
			}			
			if (e.keyCode == Keyboard.DOWN) {
				_ballastInc = _incMag;
			} else if (e.keyCode == Keyboard.UP) {
				_ballastInc = -_incMag;
			}
			_sub.stage.addEventListener(KeyboardEvent.KEY_UP, keyUpListener);			
		}		
		
		private function keyUpListener(e:KeyboardEvent):void {
			_thrust = new Vector2D(0,0);
			_ballastInc = 0;
			_rotate = false;
			_sub.stage.removeEventListener(KeyboardEvent.KEY_UP, keyUpListener);						
		}		
		
		override protected function moveObject():void{
			super.moveObject();
			rotatePropeller();
			adjustBallast();
			updateInfo();			
		}
		
		private function rotatePropeller():void{
			if (_rotate){
				_sub.propeller.rotation += 180;
			}
		}

		private function adjustBallast():void{
			if (_ballastInc != 0){
				_waterFraction += _ballastInc;
				if (_waterFraction < 0){
					_waterFraction = 0;
				}
				if (_waterFraction > 1){
					_waterFraction = 1;
				}
				setWater();
			}
		}
		
		private function setWater():void{
			_sub.water.height = _waterHeight*_waterFraction;
			_sub.mass = _emptySubMass + _waterMass*_waterFraction;
		}

		private function updateInfo():void{
			var ratio:Number = _sub.mass/_V/_rho; // stosunek gęstości łodzi podwodnej do gęstości wody
			ratio = Math.round(ratio*100)/100; // zaokrąglenie do 2 miejsc po przecinku
			_txt.text = String(ratio);
		}

		override protected function calcForce():void{
			var dr:Number = (_sub.y-_yLevel)/_sub.height;
			var ratio:Number; // fragment objętości ciała zanurzonej w płynie
			if (dr <= -1){ // gdy ciało znajduje się w całości poza wodą
				ratio=0;
			}else if (dr < 1){ // gdy ciało znajduje się częściowo w wodzie 			
				ratio = dr; // dla sześcianu
			}else{ // gdy ciało jest całkowicie zanurzone
				ratio = 1;
			}
			var gravity:Vector2D = Forces.constantGravity(_sub.mass,_g);
			var upthrust:Vector2D = Forces.upthrust(_rho,_V*ratio,_g);
			var drag:Vector2D = Forces.drag(_k*ratio,_sub.velo2D);
			force = Forces.add([gravity, upthrust, drag, _thrust]);	
		}
	
	}
}
