﻿package com.physicscodes.objects {
	import flash.display.Sprite;	
	import com.physicscodes.math.Vector2D;	
	
	public class TurbineRB extends PolygonRB{
		private var _vertices:Array=new Array();	
		private var _ri:Number;
		private var _ro:Number;

		public function TurbineRB(pri:Number,pro:Number,pcm:Vector2D,pcolor:uint=0x000000,pim:Number=1,pmass:Number=1,pcharge:Number=0){
			this.centerOfMass = pcm;
			this.momentOfInertia = pim;
			this.mass = pmass;
			this.charge = pcharge;	
			_ri = pri;
			_ro = pro;
			getVertices();
			super(_vertices,pcm,pcolor,pim,pmass,pcharge);
		}

		private function getVertices():void{
			var vertex:Vector2D;
			vertex = getVertex(_ro,0);
			_vertices.push(vertex);
			vertex = getVertex(_ri,60);
			_vertices.push(vertex);			
			vertex = getVertex(_ro,120);
			_vertices.push(vertex);
			vertex = getVertex(_ri,180);
			_vertices.push(vertex);			
			vertex = getVertex(_ro,240);
			_vertices.push(vertex);
			vertex = getVertex(_ri,300);
			_vertices.push(vertex);			
		}
		
		private function getVertex(pr:Number,pa:Number):Vector2D{
			pa *= Math.PI/180;
			return new Vector2D(pr*Math.cos(pa),pr*Math.sin(pa));
		}
	}
	
}
