﻿package com.physicscodes.objects {
	import flash.display.Sprite;	
	import flash.geom.Matrix;	
	import flash.display.GradientType;
	import com.physicscodes.math.Vector2D;	
	
	public class BallRB extends RigidBody{
		private var _radius:Number;
		private var _color:uint;
		private var _gradient:Boolean;		
		private var _sprite:Sprite;			

		public function BallRB(pcm:Vector2D,pradius:Number=20,pcolor:uint=0x000000,pim:Number=1,pmass:Number=1,pcharge:Number=0,pgradient:Boolean=true){
			this.centerOfMass = pcm;
			this.momentOfInertia = pim;
			this.mass = pmass;
			this.charge = pcharge;		
			_radius=pradius;
			_color=pcolor;
			_gradient = pgradient;	
			_sprite = new Sprite();			
			drawBall();
			super(pcm,pim,pmass,pcharge);
		}

		private function drawBall():void{
			with (_sprite.graphics){	
				if (_gradient){
					var matrix:Matrix = new Matrix();
					matrix.createGradientBox(_radius,_radius,0,-_radius,-_radius/2);					
					beginGradientFill(GradientType.RADIAL,[0xffffff,_color],[1,1],[0,255],matrix);
				}else{
					beginFill(_color);
				}
				drawCircle(0,0,_radius);
				endFill();
			}
			addChild(_sprite);
		}		
				
		public function clear():void{
			_sprite.graphics.clear();
			removeChild(_sprite);
		}

		public function get radius():Number{
			return _radius;
		}
		
		public function set radius(pradius:Number):void{
			_radius = pradius;
			clear();
			drawBall();
		}
		
		public function get color():Number{
			return _color;
		}
		
		public function set color(pcolor:Number):void{
			_color = pcolor;
			clear();
			drawBall();
		}
		
		public function get gradient():Boolean{
			return _gradient;
		}
		
		public function set gradient(pgradient:Boolean):void{
			_gradient = pgradient;
			clear();
			drawBall();
		}		
	
	}
	
}
