package {
	import com.physicscodes.motion.MultiForcer2;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.objects.Particle;	
	import com.physicscodes.math.Vector2D;
	import flash.display.Sprite;
	import flash.events.MouseEvent;		
	
	public class RopeMover extends MultiForcer2{
		private var _objects:Array;
		private var _support:Ball;
		private var _center:Vector2D;
		private var _displ:Vector2D;
		private var _g:Number=10;
		private var _kDamping:Number=20;
		private var _kSpring:Number=500;
		private var _springLength:Number=20;
		private var _spring:Sprite;
		private var _drop:Boolean=false;

		public function RopeMover(pobjects:Array,psupport:Ball,pspring:Sprite):void{
			_objects = pobjects;
			_support = psupport;
            _center = _support.pos2D;
			_spring = pspring;
			_spring.stage.addEventListener(MouseEvent.MOUSE_DOWN,onDown);										
			super(_objects);
		}
		
		override protected function moveObject():void{
			super.moveObject();
			drawSpring();				
			_center = _support.pos2D;
		}		

		override protected function calcForce(pparticle:Particle,pnum:uint):void{
			var centerPrev:Vector2D;
			var centerNext:Vector2D;
			var veloPrev:Vector2D;
			var veloNext:Vector2D;			
			if (pnum > 0){
				centerPrev = _objects[pnum-1].pos2D;
				veloPrev = _objects[pnum-1].velo2D;
			}else{
				centerPrev = _center;
				veloPrev = new Vector2D(0,0);
			}
			if (pnum < _objects.length-1){
				centerNext = _objects[pnum+1].pos2D;
				veloNext = _objects[pnum+1].velo2D;
			}else{
				centerNext = pparticle.pos2D;
				veloNext = pparticle.velo2D;
			}
			var gravity:Vector2D = Forces.constantGravity(pparticle.mass,_g);
		//	var damping:Vector2D = Forces.damping(_kDamping,pparticle.velo2D);				
			var velo:Vector2D = pparticle.velo2D.multiply(2).subtract(veloPrev).subtract(veloNext);
			var damping:Vector2D = Forces.damping(_kDamping,velo);							
			//var dampingPrev:Vector2D = Forces.damping(_kDamping,pparticle.velo2D.subtract(veloPrev));				
			//var dampingNext:Vector2D = Forces.damping(_kDamping,pparticle.velo2D.subtract(veloNext));					
			var displPrev:Vector2D = pparticle.pos2D.subtract(centerPrev);
			var displNext:Vector2D = pparticle.pos2D.subtract(centerNext);			
			var extensionPrev:Vector2D = displPrev.subtract(displPrev.unit().multiply(_springLength));
			var extensionNext:Vector2D = displNext.subtract(displNext.unit().multiply(_springLength));	
			var restoringPrev:Vector2D = Forces.spring(_kSpring,extensionPrev);
			var restoringNext:Vector2D = Forces.spring(_kSpring,extensionNext);									
			force = Forces.add([gravity, damping, restoringPrev, restoringNext]);	
//			force = Forces.add([gravity, dampingPrev, dampingNext, restoringPrev, restoringNext]);	
			if (pnum==_objects.length-1 && !_drop){
				force = new Vector2D(0,0);
				pparticle.velo2D = new Vector2D(0,0);
			}
		}			
		
		private function drawSpring():void{
			with (_spring.graphics){
				clear();		
				lineStyle(2,0x009999);
				moveTo(_center.x,_center.y);
				for (var i:uint=0; i<_objects.length; i++){ 
					var X:Number = _objects[i].xpos;
					var Y:Number = _objects[i].ypos;
					lineTo(X,Y);
				}
			}
		}
		
		private function onDown(e:MouseEvent):void{
			_spring.stage.addEventListener(MouseEvent.MOUSE_UP,onUp);
			_drop = true;
		}
		private function onUp(e:MouseEvent):void{
			_spring.stage.removeEventListener(MouseEvent.MOUSE_UP,onUp);
			_drop = false;
		}		
				
	}
}