package{
	import flash.display.Sprite;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.math.Vector2D;	
	import com.physicscodes.objects.Particle;

	public class ElectricField extends Sprite{
		public function ElectricField():void{
			init();
		}
		private function init():void{
			var timeStep:Number = 10;			
			var k:Number = 1; 	
			var numCenters = 20; 
			
			var centers:Array = new Array();
			for (var i:uint=0; i<numCenters; i++){
				var center:Ball;
				var charge:Number = (Math.random()-0.5)*1000000;
				var color:uint;
				if (charge < 0){
					color = 0xff0000;
				}else if (charge > 0){
					color = 0x0000ff;
				}else{ // obojętne elektrycznie
					color = 0x000000;
				}
				center = new Ball(20*(Math.random()+0.5),color,1,charge,true);
				center.pos2D = new Vector2D(Math.random()*stage.stageWidth,Math.random()*stage.stageHeight);
				addChild(center);		
				centers[i] = center;
			}

			var orbiter:Ball;
			orbiter = new Ball(5,0xff0000,1,1);	
			orbiter.pos2D = new Vector2D(Math.random()*stage.stageWidth,Math.random()*stage.stageHeight);
			orbiter.velo2D = new Vector2D((Math.random()-0.5)*100,(Math.random()-0.5)*100);
			addChild(orbiter);

			var electric:ElectricInteractor=new ElectricInteractor(orbiter,centers,k);		
			electric.startTime(timeStep);
		}
	}
}