package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.objects.Particle;
	import flash.display.Sprite;
	
	public class Pendulum extends Forcer{
		private var _bob:Ball;
		private var _cord:Sprite;		
		private var _center:Vector2D;
		private var _dist:Vector2D;
		private var _bobMass:Number;
		private var _lengthP:Number;		
		private var _g:Number=100;		

		public function Pendulum(pbob:Ball,pcord:Sprite,ppivotPos:Vector2D):void{
			_bob = pbob;
			_bobMass = pbob.mass;			
            _center = ppivotPos;
			_cord = pcord;
			_lengthP = _bob.pos2D.subtract(_center).length;
			super(pbob);
		}
		
		override protected function moveObject():void{		
			super.moveObject();
			drawSpring();
			//trace(time);
		}		
		
		private function drawSpring():void{
			with (_cord.graphics){
				clear();			
				lineStyle(2,0x999999);
				moveTo(_center.x,_center.y);
				lineTo(_bob.x,_bob.y)
			}
		}		

		override protected function calcForce():void{
            _dist=_bob.pos2D.subtract(_center);
			var gravity:Vector2D = Forces.constantGravity(_bobMass,_g);
			var tension:Vector2D;
			//if(_dist.length >= _lengthP) {
				tension = _dist.unit().multiply(-(gravity.projection(_dist)+_bobMass*_bob.velo2D.lengthSquared/_lengthP));
			//}else{
			//	tension = new Vector2D(0,0);
			//}
			force = Forces.add([gravity, tension]);
		}
	}
}