﻿package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.objects.Box;
	import com.physicscodes.math.Vector2D;
	
	public class CarMover extends Forcer{
		private var _car:Box;
		private var _center:Vector2D;
		private var _dist:Vector2D;
		private var _velo:Number;		
		private var _g:Number=10;
		private var _Cs:Number=1;

		public function CarMover(pcar:Box,pcenter:Vector2D):void{
			_car = pcar;
			_center = pcenter;
			_velo = pcar.velo2D.length;
			super(_car);
		}
		
		override protected function calcForce():void{
			_dist=_car.pos2D.subtract(_center);
			var centripetalForce:Vector2D = _dist.unit().multiply(-_car.mass*_velo*_velo/_dist.length);
			var radialFriction:Vector2D = _dist.unit().multiply(-_Cs*_car.mass*_g);
			if(radialFriction.length > centripetalForce.length) { 
				force = centripetalForce;
			}
			else{
				force = radialFriction;
			}
		}		
	}
}