package {
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.objects.Particle;
	
	import flash.display.Sprite;
	
	public class BungeeOscillator extends Forcer{
		private var _object:Particle;
		private var _center:Vector2D;
		private var _displ:Vector2D;
		private var _g:Number=20;
		private var _kDamping:Number=0.02;
		private var _kSpring:Number=25;
		private var _cordLength:Number=100;
		private var _spring:Sprite;

		public function BungeeOscillator(pobject:Particle,pfixedSupport:Ball,pspring:Sprite):void{
			_object = pobject;
            _center = pfixedSupport.pos2D;
			_spring = pspring;
			super(_object);
		}
		
		override protected function moveObject():void{		
			super.moveObject();
			drawSpring();
		}		
		
		private function drawSpring():void{
			with (_spring.graphics){
				clear();
				if (_displ.length > _cordLength){				
					lineStyle(2,0x999999);
				}else{
					lineStyle(1,0xcccccc);
				}
				moveTo(_center.x,_center.y);
				lineTo(_object.x,_object.y)
			}
		}
		
		override protected function calcForce():void{
			_displ=_object.pos2D.subtract(_center);
			var gravity:Vector2D = Forces.constantGravity(_object.mass,_g);
			var damping:Vector2D = Forces.drag(_kDamping,_object.velo2D);	
			var extension:Vector2D = _displ.subtract(_displ.unit().multiply(_cordLength));
			var restoring:Vector2D;
            if (_displ.length > _cordLength) {  
				restoring = Forces.spring(_kSpring,extension);
			}else{
				restoring = new Vector2D(0,0);
			}
			force = Forces.add([gravity, damping, restoring]);
		}
		
	}
}