package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Ball;			
	import com.physicscodes.math.Vector2D;
	import flash.events.Event;	
	import flash.events.KeyboardEvent;	
	import flash.ui.Keyboard;

	public class Rocketer extends Forcer{
		
		private var _rocket:Rocket;		
		private var _massPlanet:Number;		
		private var _centerPlanet:Vector2D;		
		private var _radiusPlanetSquared:Number;
		private var _G:Number = 0.1;
		private var _dmdt:Number = 0.5;
		private var _dmdtSide:Number = 0.1;		
		private var _fuelMass:Number = 3.5;
		private var _fuelSideMass:Number = 3.5;		
		private var _fuelUsed:Number = 0;
		private var _fuelSideUsed:Number = 0;		
		private var _ve:Vector2D = new Vector2D(0,200);
		private var _veSide:Vector2D = new Vector2D(-100,0);		
		private var _applySideThrust:Boolean=false;
		private var _showExhaust:Boolean=true;
		private var _orientation:int=1;

		public function Rocketer(procket:Rocket,pplanet:Ball):void{
			_rocket = procket;
			_massPlanet = pplanet.mass;			
			_centerPlanet = pplanet.pos2D;			
			_radiusPlanetSquared = pplanet.radius*pplanet.radius;		
			pplanet.stage.addEventListener(KeyboardEvent.KEY_DOWN,startSideThrust);		
			pplanet.stage.addEventListener(KeyboardEvent.KEY_UP,stopSideThrust);		
			super(procket);
		}	
		
		override protected function moveObject():void{			
			super.moveObject();		
			updateMass();
			rotateObject();
			monitor();
		}		
		
		private function startSideThrust(evt:KeyboardEvent):void{
			if (evt.keyCode==Keyboard.RIGHT){
				_applySideThrust = true;
				_orientation = 1;
			}
			if (evt.keyCode==Keyboard.LEFT){
				_applySideThrust = true;
				_orientation = -1;
			}			
		}
		
		private function stopSideThrust(evt:KeyboardEvent):void{
			_applySideThrust = false;
		}		
		
		override protected function calcForce():void{
			var gravity:Vector2D = Forces.gravity(_G,_massPlanet,_rocket.mass,_rocket.pos2D.subtract(_centerPlanet));	
			var thrust:Vector2D = new Vector2D(0,0);
			var thrustSide:Vector2D = new Vector2D(0,0);			
			if (_fuelUsed < _fuelMass){
				thrust = _ve.multiply(-_dmdt);
			}
			if (_fuelSideUsed < _fuelSideMass && _applySideThrust){
				thrustSide = _veSide.multiply(-_dmdtSide*_orientation);		
			}			
			force = Forces.add([gravity, thrust, thrustSide]);		
		}
		
		private function updateMass():void{
			if (_fuelUsed < _fuelMass){
				_fuelUsed += _dmdt*dt;
				_rocket.mass += -_dmdt*dt;							
			}
			if (_fuelSideUsed < _fuelSideMass && _applySideThrust){
				_fuelSideUsed += _dmdtSide*dt;
				_rocket.mass += -_dmdtSide*dt;
			}				
		}	
		
		private function rotateObject():void{
			_rocket.rotation = _rocket.velo2D.angle*180/Math.PI + 90;
		}
		
		private function monitor():void{	
			if (_showExhaust && _fuelUsed >= _fuelMass){
				_rocket.stopExhaust();
				_showExhaust = false;
			}
			if (_rocket.pos2D.subtract(_centerPlanet).lengthSquared < _radiusPlanetSquared){
				this.stopTime();
			}
		}
	}
}
