package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;

	public class Orbiter extends Forcer{
		
		private var _orbitingParticle:Particle;				
		private var _massOrbiter:Number;
		private var _massAttractor:Number;		
		private var _center:Vector2D;
		private var _G:Number = 1;

		public function Orbiter(porbitingParticle:Particle,pattractor:Particle):void{
			_orbitingParticle = porbitingParticle;
			_massOrbiter = porbitingParticle.mass;			
			_massAttractor = pattractor.mass;			
			_center = pattractor.pos2D;
			super(porbitingParticle);
		}	
		
		override protected function calcForce():void{
			force = Forces.gravity(_G,_massAttractor,_massOrbiter,_orbitingParticle.pos2D.subtract(_center));		
		}
	}
}
