﻿package {
	import com.physicscodes.motion.Mover;
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.math.Graph;
	import flash.events.KeyboardEvent;		
	import flash.ui.Keyboard;		

	public class Accelerator extends Mover{
		private var _particle:Particle;
		private var _powerLossFactor:Number=0.1;		
		private var _powerApplied:Number=50;
		private var _ke:Number;
		private var _vmag:Number;
		private var _mass:Number;
		private var _graph:Graph;			
		private var _applyThrust:Boolean=false;					

		public function Accelerator(pparticle:Particle):void{
			_particle = pparticle;
			_mass = _particle.mass;
			_vmag = _particle.velo2D.length;
			_ke = 0.5*_mass*_vmag*_vmag;
			setupGraphs();			
			_particle.stage.addEventListener(KeyboardEvent.KEY_DOWN,startThrust);		
			_particle.stage.addEventListener(KeyboardEvent.KEY_UP,stopThrust);
			super(pparticle);
		}	
		
		private function startThrust(evt:KeyboardEvent):void{
			if (evt.keyCode==Keyboard.UP){
				_applyThrust = true;
			}				
		}		
		
		private function stopThrust(evt:KeyboardEvent):void{
			_applyThrust = false;
		}				
		
		override protected function moveObject():void{
			super.moveObject();
			applyPower();				
			updateVelo();			
			plotGraphs();			
		}
	
		private function applyPower():void{
			if (_applyThrust){
				_ke += _powerApplied*dt;
			}
			_ke -= _powerLossFactor*_vmag*_vmag*dt;			
		}
		
		private function updateVelo():void{
			_vmag = Math.sqrt(2*_ke/_mass);
//			_particle.velo2D = new Vector2D(_vmag,0);
			_particle.vx = _vmag;
		}

		private function setupGraphs():void{
			//_graph= new Graph(xmin,xmax,ymin,ymax,xorig,yorig,xwidth,ywidth);	
			_graph= new Graph(0,60,0,50,100,550,600,400);					
			_graph.drawgrid(5,1,5,1);			
			_graph.drawaxes('time (s)','velocity (px/s)');		
			_particle.stage.addChild(_graph);			
		}
		
		private function plotGraphs():void{
			_graph.plot([time], [_particle.vx], 0xff0000, false, true);						
		}
	
	}
	
}