﻿package{
	import flash.display.GradientType;
	import flash.display.Sprite;
	import flash.geom.Matrix;
	
	public class Ball extends Sprite{
		
		private var _radius:Number;
		private var _color:uint;
		private var _vx:Number=0;
		private var _vy:Number=0;
		
		public function Ball(radius:Number=20,color:uint=0x0000ff){
			_radius=radius;
			_color=color;
			init();
		}

		private function init():void{
			var sprite:Sprite = new Sprite();
			var matrix:Matrix = new Matrix();
			
			matrix.createGradientBox(_radius,_radius,0,-_radius,-_radius/2);
			
			with (sprite.graphics){
				beginGradientFill(GradientType.RADIAL,[0xffffff,_color],[1,1],[0,255],matrix);
				drawCircle(0,0,_radius);
				endFill();
			}
			addChild(sprite);
		}

		public function get vx():Number{
			return _vx;
		}
		
		public function set vx(pvx:Number):void{
			_vx = pvx;
		}
		
		public function get vy():Number{
			return _vy;
		}
		
		public function set vy(pvy:Number):void{
			_vy = pvy;
		}		
		
	}
	
}
