package{
	import flash.display.Sprite;
	
	public class Integration extends Sprite{
		
		private var numPoints:uint=1001;
		private var numGrad:uint=1;		
		private var xRange:Number=6;
		private var xStep:Number;
		
		public function Integration(){
			init();
		}
		private function init():void{
			var graph:Graph = new Graph(-4,4,-10,10,275,210,450,350);			
			graph.drawgrid(1,0.2,2,0.5);			
			graph.drawaxes('x','y');
			addChild(graph);
			var xA:Array = new Array();
			var yA:Array = new Array();
			// oblicza funkcję
			xStep = xRange/(numPoints-1);
			for (var i:uint=0; i<numPoints; i++){
				xA[i] = (i-numPoints/2)*xStep;
				yA[i] = f(xA[i]);						   
			}
			graph.plot(xA,yA,0xff0000,false,true); // funkcja rysująca wykres
			// oblicza pochodną metodą różnic przednich
			var xAr:Array = new Array();			
			var gradA:Array = new Array();
			for (var j:uint=0; j<numPoints-numGrad; j++){
				xAr[j] = xA[j];
				gradA[j] = grad(xA[j],xA[j+numGrad]);						   
			}
			graph.plot(xAr,gradA,0x0000ff,false,true); // funkcja rysująca wykres pochodnej
			// oblicza całkę metodą różnic przednich
			var xAi:Array = new Array();			
			var integA:Array = new Array();
			xAi[0] = -3;
			integA[0] = 9;
			for (var k:uint=1; k<numPoints; k++){
				xAi[k] = xA[k];
				integA[k] = integA[k-1] + f(xA[k-1])*(xA[k]-xA[k-1]);   
			}
			graph.plot(xAi,integA,0x00ff00,false,true); // rysuje wykres wyniku całkowania			
		}
		private function f(x:Number):Number{
			var y:Number;
			y = 2*x;
			return y;
		}
		private function grad(x1:Number,x2:Number):Number{
			return (f(x1)-f(x2))/(x1-x2);
		}
		private function integ(x1:Number,x2:Number):Number{
			return (f(x1)-f(x2))/(x1-x2);
		}		
	}
}