package 
{
	import com.physicscodes.motion.ForcerRB3D;
	import com.physicscodes.motion.Forces3D;
	import com.physicscodes.objects.PolyhedronRB;
	import com.physicscodes.objects.Particle;	
	import flash.geom.Vector3D;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.ui.Keyboard;
	import flash.text.TextField;
	import flash.display.Sprite;

	public class AirplaneMover extends ForcerRB3D
	{
		// samolot i jego właściwości; wartości podawane w jednostkach układu SI
		private var _airplane:PolyhedronRB;
		private var _massAirplane:Number;
		private var _areaWing:Number = 150;
		private var _areaVerticalTail:Number = 20;
		private var _areaHorizontalTail:Number = 6;
		private var _areaAileron:Number = 4;	// powierzchnia jednej lotki 		
		private var _distVtToCM:Number = 35;	// odległość pionowego steru od środka masy 
		private var _distAlToCM:Number = 9; 	// odległość lotki od środka masy w metrach

		// współczynniki oporu i nośności
		//private var _cDrag:Number = 0.03;// współczynnik oporu (zakładamy, że stały)
		private var _cDrag:Number = 1;// współczynnik oporu (zakładamy, że stały)
		private var _cLift:Number; // współczynnik nośności 		
		private var _dcLdalpha:Number = 5; // pochodna dcLift/d(alpha) (z założenia także stała)
		private var _kDrag:Number;

		// kąty
		private var _alph:Number = 0;// kąt pomiędzy rzutem wektora prędkości na płaszczyzną xy a osią samolotu  (ix) 
		private var _beta:Number = 0;// kąt pomiędzy rzutem wektora prędkości na płaszczyzną xz a osią samolotu  (ix)
		// kąt natarcia skrzydła; ustalony
		private var _alphWing:Number = 10*Math.PI/180; // _alphWing is the pitch of the wings w.r.t. the fuselage (ix axis)

		// przemieszczenia kątowe powierzchni kontrolnych
		private var _alphEl:Number = 0.0;	// kąt przemieszczenia steru poziomego określany przez użytkownika 
		private var _alphElMax:Number = 10*Math.PI/180;	// wartość maksymalna
		private var _alphElInc:Number = 0.5*Math.PI/180; 	// wzrost
		
		private var _alphAl:Number = 0.0;	// kąt przemieszczenia lotek określany przez użytkownika
		private var _alphAlMax:Number = 2*Math.PI/180;	// wartość maksymalna
		private var _alphAlInc:Number = 0.1*Math.PI/180; 	// wzrost
		
		private var _alphRd:Number = 0.0;	// kąt przemieszczenia steru pionowego określany przez użytkownika 
		private var _alphRdMax:Number = 10*Math.PI/180;	// wartość maksymalna
		private var _alphRdInc:Number = 0.5*Math.PI/180; 	// wzrost				

		// odrzut/napęd
		private var _thrustMag:Number = 0;	// odrzut/napęd jest określany przez użytkownika
		private var _thrustMax:Number = 300000; // maksymalna wartość odrzutu
		private var _thrustInc:Number = 10000; // krok zwiększania odrzutu/napędu

		// parametry otoczenia
		private var _g:Number = 10; // przyśpieszenie grawitacyjne
		private var _rho:Number = 1.0; // gęstość powietrza (zmniejsza się ze wzrostem wysokości; tu przyjęliśmy stałą, lecz zmniejszoną wartość)
		private var _kAng:Number = 0.2; // współczynnik tłumienia prędkości kątowej					
		private var _groundLevel:Number = 600;	// położenie na ziemi w pikselach

		// pola tekstowe wyświetlające informacje o locie
		private var _txtAltitude:TextField;
		private var _txtLocation:TextField;
		private var _txtHorizontalVelo:TextField;
		private var _txtVerticalVelo:TextField;
		private var _txtControls:TextField;
		
		public function AirplaneMover(pairplane:PolyhedronRB):void
		{
			_airplane = pairplane;
			_massAirplane = _airplane.mass;
			_kDrag = 0.5*_rho*_areaWing*_cDrag;
			_airplane.stage.addEventListener(KeyboardEvent.KEY_DOWN,startControl);
			setupDisplay();			
			super(_airplane);
		}

		private function setupDisplay():void{
			_txtAltitude = new TextField();
			_txtAltitude.x = 600;
			_txtAltitude.y = 50;
			_txtAltitude.width = 200;
			_airplane.stage.addChild(_txtAltitude);
			_txtVerticalVelo = new TextField();
			_txtVerticalVelo.x = 600;
			_txtVerticalVelo.y = 100;
			_txtVerticalVelo.width = 200;
			_airplane.stage.addChild(_txtVerticalVelo);				
			_txtLocation = new TextField();
			_txtLocation.x = 600;
			_txtLocation.y = 150;
			_txtLocation.width = 200;
			_airplane.stage.addChild(_txtLocation);			
			_txtHorizontalVelo = new TextField();
			_txtHorizontalVelo.x = 600;
			_txtHorizontalVelo.y = 200;
			_txtHorizontalVelo.width = 200;
			_airplane.stage.addChild(_txtHorizontalVelo);			
			_txtControls = new TextField();
			_txtControls.x = 50;
			_txtControls.y = 50;
			_txtControls.width = 200;
			_airplane.stage.addChild(_txtControls);			
			updateDisplay();
		}
		
		private function updateDisplay():void{
			_txtAltitude.text = "Altitude = " + Math.round(_groundLevel-_airplane.y);
			_txtVerticalVelo.text = "Vertical velocity = " + Math.round(_airplane.vy*10)/10;									
			_txtLocation.text = "Location = (" + Math.round(_airplane.x) + ", " + Math.round(_airplane.z) + ")";
			_txtHorizontalVelo.text = "Horizontal velocity = (" + Math.round(_airplane.vx*10)/10 + ", " + Math.round(_airplane.vz*10)/10 + ")";
		}

		override protected function moveObject():void{
			super.moveObject();
			updateObject();
			updateDisplay();
		}		

		private function updateObject():void{
			var vec:Vector3D = _airplane.angVelo;
			vec.scaleBy(dt);
			_airplane.clear();
			_airplane.updatePolyhedron(vec.x,vec.y,vec.z);
		}

		private function startControl(evt:KeyboardEvent):void
		{
			// Ster poziomy: pochylenie 
			if (evt.keyCode == Keyboard.UP){
				if (_alphEl < _alphElMax){ // maksymalny kąt steru poziomego
					_alphEl += _alphElInc;
				}
				_txtControls.text = "Elevators angle = " + Math.floor(_alphEl*180/Math.PI*10)/10;
			}
			if (evt.keyCode == Keyboard.DOWN){
				if (_alphEl > -_alphElMax){ // minimalny kąt steru poziomego
					_alphEl += -_alphElInc;
				}
				_txtControls.text = "Elevators angle = " + Math.floor(_alphEl*180/Math.PI*10)/10;
			}
			// Lotki: przechylenie
			if (evt.keyCode == Keyboard.LEFT){
				if (_alphAl > -_alphAlMax){ // minimalny kąt lotek 
					_alphAl += -_alphAlInc;
				}
				_txtControls.text = "Ailerons angle = " + Math.floor(_alphAl*180/Math.PI*10)/10;
			}
			if (evt.keyCode == Keyboard.RIGHT){
				if (_alphAl < _alphAlMax){ // maksymalny kąt lotek
					_alphAl += _alphAlInc;
				}
				_txtControls.text = "Ailerons angle = " + Math.floor(_alphAl*180/Math.PI*10)/10;
			}			
			// Ster pionowy: odchylenie
			if (evt.keyCode == Keyboard.CONTROL){
				if (_alphRd > -_alphRdMax){ // minimalny kąt steru pionowego
					_alphRd += -_alphRdInc;
				}
				_txtControls.text = "Rudder angle = " + Math.floor(_alphRd*180/Math.PI*10)/10;
			}
			if (evt.keyCode == Keyboard.SHIFT){
				if (_alphRd < _alphRdMax){ // maksymalny kąt steru pionowego
					_alphRd += _alphRdInc;
				}
				_txtControls.text = "Rudder angle = " + Math.floor(_alphRd*180/Math.PI*10)/10;
			}
			// sterowanie odrzutem
			if (evt.keyCode == Keyboard.SPACE){
				if (Keyboard.capsLock){
					if (_thrustMag > 0){
						_thrustMag += -_thrustInc;
					}
				}else{
					if (_thrustMag < _thrustMax){
						_thrustMag += _thrustInc;
					}
				}
				_txtControls.text = "Thrust = " + _thrustMag;
			}
		}

		override protected function calcForce():void
		{
			// aktualizuje położenie osi samolotu
			var ix:Vector3D = _airplane.ix;// wektor jednostkowy osi x 
			var iy:Vector3D = _airplane.iy;// wektor jednostkowy osi y
			var iz:Vector3D = _airplane.iz;// wektor jednostkowy osi z 
			
			// *** siły działające na cały samolot ***
			if(_airplane.ypos < _groundLevel){
				force = Forces3D.constantGravity(_massAirplane,_g);	// przyśpieszenie grawitacyjne
			}else{
				force= new Vector3D(0,0,0); // siła reakcji podłoża
			}
			force=force.add(Forces3D.drag(_kDrag,_airplane.velo)); // dodaje siłę oporu

			var thrust:Vector3D; 
			if (_thrustMag > 0){
				thrust = ix.clone();
				thrust.scaleBy(_thrustMag);
			}else{
				thrust = new Vector3D(0,0,0);
			}
			force = force.add(thrust); // dodaje siłę odrzutu
			
			// *** momenty sił działające na cały samolot ***
			torque = new Vector3D(0,0,0); // przyśpieszenie grawitacyjne, opór i odrzut nie wytwarzają moemntów sił
			
			// ale dla równowagi dodamy tłumienie ruchu obrotowego
			var vec:Vector3D = _airplane.angVelo;
			vec.scaleBy(-_kAng);
			torque = torque.add(vec);
			
			
			// *** Rozważmy teraz siły nośne na skrzydłach i powierzchniach sterowych ***
			if (_airplane.velo.length > 0){ // przy zerowej prędkości siła nośna nie pojawia się
				var viX:Number = _airplane.velo.dotProduct(ix);// prędkość samolotu wzdłuż osi x 
				var viY:Number = _airplane.velo.dotProduct(iy);// prędkość samolotu wzdłuż osi y
				var viZ:Number = _airplane.velo.dotProduct(iz);// prędkość samolotu wzdłuż osi z 
				                                                 
				var vecX:Vector3D = ix.clone();
				var vecY:Vector3D = iy.clone();
				vecY.scaleBy(viY);
				vecX.scaleBy(viX);
				var viXY:Vector3D = vecX.add(vecY); // prędkość samolotu w płaszczyźnie xy 
				                                                
				vecX = ix.clone();
				var vecZ:Vector3D = iz.clone();
				vecX.scaleBy(viX);
				vecZ.scaleBy(viZ);
				var viZX:Vector3D = vecX.add(vecZ); // prędkość samolotu w płaszczyźnie xz 
				
				// oblicza kąt natarcia i kąt boczny
				_alph = Math.atan2(viY,viX); // zatem kąt natarcia
				if ((viY==0) && (viX==0)){
					_alph = 0;
				}
				_beta = Math.atan2(viZ,viX);// kąt boczny
				if ((viZ==0) && (viX==0)){
					_beta = 0;
				}

				// siła nośna działająca na skrzydło
				var veloXY:Vector3D = viXY.clone();
				veloXY = veloXY.crossProduct(iz);
				if (Math.abs(_alph+_alphWing) > 20*Math.PI/180){
					_cLift = 1.2*_alph/Math.abs(_alph)  // warunek ograniczający wartość _cLift
				}else{
					_cLift = _dcLdalpha*(_alph+_alphWing); 
				}
				veloXY.scaleBy(0.5*_rho*viXY.length*_areaWing*_cLift);
				var liftW:Vector3D = veloXY.clone();
				force = force.add(liftW);
			
				// zakładamy, że na skrzydło nie działa moment siły
			
				// *** siły nośne i momenty sił działające na powierzchnie sterowe ***

				// para sił działająca na lotki (nie obliczamy wypadkowej)  

				// moment siły - lotki
				veloXY = viXY.clone();
				veloXY = veloXY.crossProduct(iz);
				veloXY.scaleBy(0.5*_rho*viXY.length*_areaAileron*_dcLdalpha*(_alphAl));
				var liftAl:Vector3D = veloXY.clone(); // siła nośna na jednej lotce 
				var ptorque:Vector3D = iz.crossProduct(liftAl);// T = r x F, r jest wektorem w kierunku iz, czyli wzdłuż skrzydła 
				ptorque.scaleBy(_distAlToCM*2); // współczynnik 2, bo dwie lotki dają podwójny moment siły
				torque = torque.add(ptorque);

				// siła działająca na ster poziomy; obliczana tak samo jak dla skrzydeł 
				veloXY = viXY.clone();
				veloXY = veloXY.crossProduct(iz); // wektor krążenia ma ten sam zwrot co wektor iz
				if(Math.abs(_alphEl+_alph) > 20*Math.PI/180){
					_cLift = 1.2*(_alphEl+_alph)/Math.abs(_alphEl+_alph)  // warunek ograniczający wartość _cLift
				}else{
					_cLift = _dcLdalpha*(_alphEl+_alph); 
				}
				
				veloXY.scaleBy(0.5*_rho*viXY.length*_areaHorizontalTail*_cLift);
				var liftHt:Vector3D = veloXY.clone();
				force = force.add(liftHt);
				// moment siły - ster poziomy
				ptorque = ix.crossProduct(liftHt); // T = r x liftHt; r to wektor w kierunku osi ix
				ptorque.scaleBy((-1)*_distVtToCM); // pamiętaj, że ujemna odległość wzdłuż osi ix jest mierzona w kierunku ogona samolotu
				torque = torque.add(ptorque);

				// siła na sater pionowy; liczona tak samo jak dla skrzydeł
				var veloZX:Vector3D = viZX.clone();
				veloZX = veloZX.crossProduct(iy); // pamiętaj, że oś poziomego steru jest pozioma, tzn. pokrywa się z osią iy.
				if(Math.abs(_alphRd+_beta) > 20*Math.PI/180){
					_cLift = 1.2*(_alphRd+_beta)/Math.abs(_alphRd+_beta)  // warunek ograniczający wartość _cLift
				}
				else{
					_cLift = _dcLdalpha*(_alphRd+_beta); //_beta pełni funkcję tłumienia aerodynamicznego
				}
				veloZX.scaleBy(-0.5*_rho*viZX.length*_areaVerticalTail*_cLift); 
				var _liftVt:Vector3D = veloZX.clone();
				force = force.add(_liftVt);
				// moment siły - ster pionowy
				ptorque = ix.crossProduct(_liftVt);// T = r x liftVt ; pamiętaj, że wektor r ma kierunek osi ix 
				ptorque.scaleBy(-_distVtToCM);
				torque = torque.add(ptorque); 
			}


		}
		
	}
}