﻿package {
	public class Vector2D {
		private var _x:Number;
		private var _y:Number;		
		public function Vector2D(px:Number,py:Number):void {
			_x = px;
			_y = py;
		}
		public function get x():Number{
			return _x;
		}
		public function set x(px:Number):void{
			_x = px;
		}		
		public function get y():Number{
			return _y;
		}
		public function set y(py:Number):void{
			_y = py;
		}		
		public function get length():Number{
			return Math.sqrt(lengthSquared);
		}
		public function get lengthSquared():Number{
			return _x*_x + _y*_y;
		}	
		public function clone():Vector2D {
			return new Vector2D(_x,_y);
		}
		public function negate(vec:Vector2D):void {
			_x = - _x;
			_y = - _y;
		}
		public function normalize():Number {
			if (length > 0) {
				_x /= length;
				_y /= length;
			}
			return length;
		}
		public function add(vec:Vector2D):Vector2D {
			return new Vector2D(_x + vec.x,_y + vec.y);
		}
		public function incrementBy(vec:Vector2D):void {
			_x += vec.x;
			_y += vec.y;
		}		
		public function subtract(vec:Vector2D):Vector2D {
			return new Vector2D(_x - vec.x,_y - vec.y);
		}
		public function decrementBy(vec:Vector2D):void {
			_x -= vec.x;
			_y -= vec.y;
		}		
		public function scaleBy(k:Number):void {
			_x *= k;
			_y *= k;
		}
		public function dotProduct(vec:Vector2D):Number {
			return _x*vec.x + _y*vec.y;
		}
		static public function distance(vec1:Vector2D,vec2:Vector2D):Number{
			return (vec1.subtract(vec2)).length; 
		}
		static public function angleBetween(vec1:Vector2D,vec2:Vector2D):Number{
			return Math.acos(vec1.dotProduct(vec2)/(vec1.length*vec2.length));
		}
	}
}